/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics.jmx;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.server.metrics.MonitorSystemConfig;
import io.digdag.server.metrics.jmx.ImmutableJmxMonitorSystemConfig;
import io.digdag.spi.metrics.DigdagMetrics;
import java.util.Map;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableJmxMonitorSystemConfig.class)
@Value.Immutable
public interface JmxMonitorSystemConfig
extends MonitorSystemConfig {
    @Override
    @Value.Default
    default public boolean getMonitorSystemEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryDefaultEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryAgentEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryApiEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryDbEnable() {
        return true;
    }

    @Override
    @Value.Default
    default public boolean getCategoryExecutorEnable() {
        return true;
    }

    public static JmxMonitorSystemConfig load(Config config) {
        Map<DigdagMetrics.Category, Boolean> categories = MonitorSystemConfig.getEnabledCategories((Optional<String>)config.getOptional("metrics.jmx.categories", String.class));
        return ImmutableJmxMonitorSystemConfig.builder().categoryAgentEnable(categories.get(DigdagMetrics.Category.AGENT)).categoryApiEnable(categories.get(DigdagMetrics.Category.API)).categoryDbEnable(categories.get(DigdagMetrics.Category.DB)).categoryExecutorEnable(categories.get(DigdagMetrics.Category.EXECUTOR)).categoryDefaultEnable(categories.get(DigdagMetrics.Category.DEFAULT)).build();
    }

    public static JmxMonitorSystemConfig disabled() {
        return ImmutableJmxMonitorSystemConfig.builder().monitorSystemEnable(false).build();
    }
}

