/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.client.api.RestSession;
import io.digdag.client.api.RestSessionAttempt;
import io.digdag.client.api.RestSessionAttemptCollection;
import io.digdag.client.api.RestSessionCollection;
import io.digdag.client.config.Config;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.repository.ProjectStore;
import io.digdag.core.repository.ProjectStoreManager;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.repository.StoredProject;
import io.digdag.core.session.SessionStore;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSession;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.session.StoredSessionWithLastAttempt;
import io.digdag.metrics.DigdagTimed;
import io.digdag.server.rs.AuthenticatedResource;
import io.digdag.server.rs.QueryParamValidator;
import io.digdag.server.rs.RestModels;
import io.digdag.spi.ac.AccessControlException;
import io.digdag.spi.ac.AccessController;
import io.digdag.spi.ac.SiteTarget;
import io.digdag.spi.ac.WorkflowTarget;
import io.digdag.spi.metrics.DigdagMetrics;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(value="Session")
@Path(value="/")
@Produces(value={"application/json"})
public class SessionResource
extends AuthenticatedResource {
    private final ProjectStoreManager rm;
    private final SessionStoreManager sm;
    private final TransactionManager tm;
    private final AccessController ac;
    private static int MAX_SESSIONS_PAGE_SIZE;
    private static final int DEFAULT_SESSIONS_PAGE_SIZE = 100;
    private static int MAX_ATTEMPTS_PAGE_SIZE;
    private static final int DEFAULT_ATTEMPTS_PAGE_SIZE = 100;
    private final DigdagMetrics metrics;

    @Inject
    public SessionResource(ProjectStoreManager rm, SessionStoreManager sm, TransactionManager tm, AccessController ac, Config systemConfig, DigdagMetrics metrics) {
        this.rm = rm;
        this.sm = sm;
        this.tm = tm;
        this.ac = ac;
        this.metrics = metrics;
        MAX_SESSIONS_PAGE_SIZE = (Integer)systemConfig.get("api.max_sessions_page_size", Integer.class, (Object)100);
        MAX_ATTEMPTS_PAGE_SIZE = (Integer)systemConfig.get("api.max_attempts_page_size", Integer.class, (Object)100);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @Path(value="/api/sessions")
    @ApiOperation(value="List sessions")
    public RestSessionCollection getSessions(@ApiParam(value="list sessions whose id is grater than this id for pagination", required=false) @QueryParam(value="last_id") Long lastId, @ApiParam(value="number of sessions to return", required=false) @QueryParam(value="page_size") Integer pageSize) throws AccessControlException {
        int validPageSize = QueryParamValidator.validatePageSize((Optional<Integer>)Optional.fromNullable((Object)pageSize), MAX_SESSIONS_PAGE_SIZE, 100);
        SiteTarget siteTarget = SiteTarget.of((int)this.getSiteId());
        this.ac.checkListSessionsOfSite(siteTarget, this.getAuthenticatedUser());
        return (RestSessionCollection)this.tm.begin(() -> {
            ProjectStore rs = this.rm.getProjectStore(this.getSiteId());
            SessionStore ss = this.sm.getSessionStore(this.getSiteId());
            List sessions = ss.getSessions(validPageSize, Optional.fromNullable((Object)lastId), this.ac.getListSessionsFilterOfSite(siteTarget, this.getAuthenticatedUser()));
            return RestModels.sessionCollection(rs, sessions);
        });
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @Path(value="/api/sessions/{id}")
    @ApiOperation(value="Get a session")
    public RestSession getSession(@ApiParam(value="session id", required=true) @PathParam(value="id") long id) throws ResourceNotFoundException, AccessControlException {
        return (RestSession)this.tm.begin(() -> {
            StoredSessionWithLastAttempt session = this.sm.getSessionStore(this.getSiteId()).getSessionById(id);
            StoredProject proj = this.rm.getProjectStore(this.getSiteId()).getProjectById(session.getProjectId());
            this.ac.checkGetSession(WorkflowTarget.of((int)this.getSiteId(), (String)session.getWorkflowName(), (String)proj.getName()), this.getAuthenticatedUser());
            return RestModels.session(session, proj.getName());
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    @DigdagTimed(category="api", appendMethodName=true)
    @GET
    @Path(value="/api/sessions/{id}/attempts")
    @ApiOperation(value="List attempts of a session")
    public RestSessionAttemptCollection getSessionAttempts(@ApiParam(value="session id", required=true) @PathParam(value="id") long id, @ApiParam(value="list attempts whose id is grater than this id for pagination", required=false) @QueryParam(value="last_id") Long lastId, @ApiParam(value="number of attempts to return", required=false) @QueryParam(value="page_size") Integer pageSize) throws ResourceNotFoundException, AccessControlException {
        int validPageSize = QueryParamValidator.validatePageSize((Optional<Integer>)Optional.fromNullable((Object)pageSize), MAX_ATTEMPTS_PAGE_SIZE, 100);
        return (RestSessionAttemptCollection)this.tm.begin(() -> {
            ProjectStore rs = this.rm.getProjectStore(this.getSiteId());
            SessionStore ss = this.sm.getSessionStore(this.getSiteId());
            StoredSessionWithLastAttempt session = ss.getSessionById(id);
            StoredProject project = rs.getProjectById(session.getProjectId());
            this.ac.checkGetAttemptsFromSession(WorkflowTarget.of((int)this.getSiteId(), (String)session.getWorkflowName(), (String)project.getName()), this.getAuthenticatedUser());
            List attempts = ss.getAttemptsOfSession(id, validPageSize, Optional.fromNullable((Object)lastId));
            List<RestSessionAttempt> collection = attempts.stream().map(arg_0 -> SessionResource.lambda$getSessionAttempts$2((StoredSession)session, project, arg_0)).collect(Collectors.toList());
            return RestModels.attemptCollection(collection);
        }, ResourceNotFoundException.class, AccessControlException.class);
    }

    private static /* synthetic */ RestSessionAttempt lambda$getSessionAttempts$2(StoredSession session, StoredProject project, StoredSessionAttempt attempt) {
        return RestModels.attempt(session, attempt, project.getName());
    }
}

