/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.rs;

import com.google.common.base.Optional;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/")
public class UiResource {
    private final ClassLoader classLoader = UiResource.class.getClassLoader();
    private final Response indexResponse = (Response)this.getResourceIfExists("public/index.html").or((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());

    @GET
    @Path(value="/assets/{path}")
    public Response getAssets(@PathParam(value="path") String path) throws IOException {
        return (Response)this.getResourceIfExists("public/assets/" + path).or(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @GET
    @Path(value="/{path:.*}")
    public Response getApplication(@PathParam(value="path") String path) throws IOException {
        if (path.isEmpty()) {
            return this.indexResponse;
        }
        return (Response)this.getResourceIfExists("public/" + path).or((Object)this.indexResponse);
    }

    private Optional<Response> getResourceIfExists(String name) throws IOException {
        try {
            byte[] bytes;
            URL resource = Resources.getResource((String)name);
            try {
                bytes = Resources.toByteArray((URL)resource);
            }
            catch (NullPointerException e) {
                return Optional.absent();
            }
            Response response = Response.ok((Object)bytes).type(URLConnection.guessContentTypeFromName(name)).build();
            return Optional.of((Object)response);
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }
}

