/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.dropwizard.jersey.caching.CacheControlledResponseFeature;
import io.dropwizard.jersey.guava.OptionalMessageBodyWriter;
import io.dropwizard.jersey.guava.OptionalParamFeature;
import io.dropwizard.jersey.sessions.SessionFactoryProvider;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardResourceConfig
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardResourceConfig.class);
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private String urlPattern;

    public DropwizardResourceConfig(MetricRegistry metricRegistry) {
        this(false, metricRegistry);
    }

    public DropwizardResourceConfig() {
        this(true, null);
    }

    public DropwizardResourceConfig(boolean testOnly, MetricRegistry metricRegistry) {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        this.urlPattern = "/*";
        this.property("jersey.config.server.wadl.disableWadl", Boolean.TRUE);
        if (!testOnly) {
            this.register(new ComponentLoggingListener(this));
        }
        this.register(new InstrumentedResourceMethodApplicationListener(metricRegistry));
        this.register(CacheControlledResponseFeature.class);
        this.register(OptionalMessageBodyWriter.class);
        this.register(OptionalParamFeature.class);
        this.register((Object)new SessionFactoryProvider.Binder());
    }

    public static DropwizardResourceConfig forTesting(MetricRegistry metricRegistry) {
        return new DropwizardResourceConfig(true, metricRegistry);
    }

    public void logComponents() {
        LOGGER.debug("resources = {}", this.canonicalNamesByAnnotation(Path.class));
        LOGGER.debug("providers = {}", this.canonicalNamesByAnnotation(Provider.class));
        LOGGER.info(this.getEndpointsInfo());
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    @VisibleForTesting
    Set<Class<?>> allClasses() {
        HashSet allClasses = Sets.newHashSet((Iterable)this.getClasses());
        for (Object singleton : this.getSingletons()) {
            allClasses.add(singleton.getClass());
        }
        return allClasses;
    }

    private Set<String> canonicalNamesByAnnotation(Class<? extends Annotation> annotation) {
        HashSet result = Sets.newHashSet();
        for (Class clazz : this.getClasses()) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            result.add(clazz.getCanonicalName());
        }
        return result;
    }

    public String getEndpointsInfo() {
        StringBuilder msg = new StringBuilder(1024);
        msg.append("The following paths were found for the configured resources:");
        msg.append(NEWLINE).append(NEWLINE);
        HashSet allResources = Sets.newHashSet();
        for (Class<?> clazz : this.allClasses()) {
            if (clazz.isInterface() || Resource.from(clazz) == null) continue;
            allResources.add(clazz);
        }
        if (!allResources.isEmpty()) {
            for (Class<Object> klass : allResources) {
                Joiner.on((String)NEWLINE).appendTo(msg, new EndpointLogger(this.urlPattern, klass).getEndpoints());
                msg.append(NEWLINE);
            }
        } else {
            msg.append("    NONE").append(NEWLINE);
        }
        return msg.toString();
    }

    private static class ComponentLoggingListener
    implements ApplicationEventListener {
        final DropwizardResourceConfig config;

        public ComponentLoggingListener(DropwizardResourceConfig config) {
            this.config = config;
        }

        public void onEvent(ApplicationEvent event) {
            if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
                this.config.logComponents();
            }
        }

        public RequestEventListener onRequest(RequestEvent requestEvent) {
            return null;
        }
    }

    private static class EndpointLogger {
        private final String rootPath;
        private final List<String> endpoints = Lists.newArrayList();

        public EndpointLogger(String urlPattern, Class<?> klass) {
            this.rootPath = urlPattern.endsWith("/*") ? urlPattern.substring(0, urlPattern.length() - 1) : urlPattern;
            this.populateEndpoints(this.rootPath, klass, false);
        }

        private void populateEndpoints(String basePath, Class<?> klass, boolean isLocator) {
            this.populateEndpoints(basePath, klass, isLocator, Resource.from(klass));
        }

        private void populateEndpoints(String basePath, Class<?> klass, boolean isLocator, Resource resource) {
            if (!isLocator) {
                basePath = this.normalizePath(basePath, resource.getPath());
            }
            for (ResourceMethod method : resource.getResourceMethods()) {
                this.endpoints.add(this.formatEndpoint(method.getHttpMethod(), basePath, klass));
            }
            for (Resource childResource : resource.getChildResources()) {
                for (ResourceMethod method : childResource.getResourceMethods()) {
                    String path;
                    if (method.getType() == ResourceMethod.JaxrsType.RESOURCE_METHOD) {
                        path = this.normalizePath(basePath, childResource.getPath());
                        this.endpoints.add(this.formatEndpoint(method.getHttpMethod(), path, klass));
                        continue;
                    }
                    if (method.getType() != ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR) continue;
                    path = this.normalizePath(basePath, childResource.getPath());
                    this.populateEndpoints(path, method.getInvocable().getRawResponseType(), true);
                }
            }
        }

        private String formatEndpoint(String method, String path, Class<?> klass) {
            return String.format("    %-7s %s (%s)", method, path, klass.getCanonicalName());
        }

        private String normalizePath(String basePath, String path) {
            if (basePath.endsWith("/")) {
                return path.startsWith("/") ? basePath + path.substring(1) : basePath + path;
            }
            return path.startsWith("/") ? basePath + path : basePath + "/" + path;
        }

        public List<String> getEndpoints() {
            return Ordering.natural().sortedCopy(this.endpoints);
        }
    }
}

