/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import io.dropwizard.jersey.errors.ErrorMessage;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public abstract class LoggingExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExceptionMapper.class);

    public Response toResponse(E exception) {
        if (exception instanceof WebApplicationException) {
            Response response = ((WebApplicationException)exception).getResponse();
            Response.Status.Family family = response.getStatusInfo().getFamily();
            if (family.equals((Object)Response.Status.Family.REDIRECTION)) {
                return response;
            }
            if (family.equals((Object)Response.Status.Family.SERVER_ERROR)) {
                this.logException(exception);
            }
            return Response.fromResponse((Response)response).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(response.getStatus(), ((Throwable)exception).getLocalizedMessage())).build();
        }
        long id = this.logException(exception);
        return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(this.formatErrorMessage(id, exception))).build();
    }

    protected String formatErrorMessage(long id, E exception) {
        return String.format("There was an error processing your request. It has been logged (ID %016x).", id);
    }

    protected long logException(E exception) {
        long id = ThreadLocalRandom.current().nextLong();
        this.logException(id, exception);
        return id;
    }

    protected void logException(long id, E exception) {
        LOGGER.error(this.formatLogMessage(id, (Throwable)exception), exception);
    }

    protected String formatLogMessage(long id, Throwable exception) {
        return String.format("Error handling a request: %016x", id);
    }
}

