/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowedMethodsFilter
implements Filter {
    public static final String ALLOWED_METHODS_PARAM = "allowedMethods";
    public static final ImmutableSet<String> DEFAULT_ALLOWED_METHODS = ImmutableSet.of((Object)"GET", (Object)"POST", (Object)"PUT", (Object)"DELETE", (Object)"HEAD", (Object)"OPTIONS", (Object[])new String[]{"PATCH"});
    private static final Logger LOG = LoggerFactory.getLogger(AllowedMethodsFilter.class);
    private ImmutableSet<String> allowedMethods;

    public void init(FilterConfig config) {
        this.allowedMethods = Optional.ofNullable(config.getInitParameter(ALLOWED_METHODS_PARAM)).map(p -> ImmutableSet.copyOf((Object[])p.split(","))).orElse(DEFAULT_ALLOWED_METHODS);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.allowedMethods.contains((Object)request.getMethod())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            LOG.debug("Request with disallowed method {} blocked", (Object)request.getMethod());
            response.sendError(405);
        }
    }

    public void destroy() {
    }
}

