/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import io.dropwizard.util.Duration;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
public class RuntimeFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final float NANOS_IN_SECOND = Duration.seconds((long)1L).toNanoseconds();
    private static final String RUNTIME_HEADER = "X-Runtime";
    private static final String RUNTIME_PROPERTY = "io.dropwizard.jersey.filter.runtime";

    public void filter(ContainerRequestContext request) throws IOException {
        request.setProperty(RUNTIME_PROPERTY, (Object)System.nanoTime());
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        Long startTime = (Long)request.getProperty(RUNTIME_PROPERTY);
        if (startTime != null) {
            float seconds = (float)(System.nanoTime() - startTime) / NANOS_IN_SECOND;
            response.getHeaders().putSingle((Object)RUNTIME_HEADER, (Object)String.format("%.6f", Float.valueOf(seconds)));
        }
    }
}

