/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.sessions;

import io.dropwizard.jersey.sessions.Flash;
import io.dropwizard.jersey.sessions.FlashFactory;
import io.dropwizard.jersey.sessions.HttpSessionFactory;
import io.dropwizard.jersey.sessions.Session;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpSession;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
public class SessionFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public SessionFactoryProvider(MultivaluedParameterExtractorProvider extractorProvider, ServiceLocator injector) {
        super(extractorProvider, injector, new Parameter.Source[]{Parameter.Source.UNKNOWN});
    }

    @Nullable
    protected Factory<?> createValueFactory(Parameter parameter) {
        Class classType = parameter.getRawType();
        Session sessionAnnotation = (Session)parameter.getAnnotation(Session.class);
        if (sessionAnnotation == null) {
            return null;
        }
        if (classType.isAssignableFrom(HttpSession.class)) {
            return new HttpSessionFactory(sessionAnnotation.doNotCreate());
        }
        if (classType.isAssignableFrom(Flash.class)) {
            return new FlashFactory(sessionAnnotation.doNotCreate());
        }
        return null;
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(SessionFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(SessionInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Session>>(){}).in(Singleton.class);
        }
    }

    public static class SessionInjectionResolver
    extends ParamInjectionResolver<Session> {
        public SessionInjectionResolver() {
            super(SessionFactoryProvider.class);
        }
    }
}

