/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation.selfvalidating;

import io.dropwizard.validation.InterpolationHelper;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collections;
import java.util.Map;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;

public class ViolationCollector {
    private final ConstraintValidatorContext constraintValidatorContext;
    private boolean violationOccurred = false;

    public ViolationCollector(ConstraintValidatorContext constraintValidatorContext) {
        this.constraintValidatorContext = constraintValidatorContext;
    }

    public void addViolation(String message) {
        this.addViolation(message, Collections.emptyMap());
    }

    public void addViolation(String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        this.getContextWithMessageParameters(messageParameters).buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }

    public void addViolation(String propertyName, String message) {
        this.addViolation(propertyName, message, Collections.emptyMap());
    }

    public void addViolation(String propertyName, String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        this.getContextWithMessageParameters(messageParameters).buildConstraintViolationWithTemplate(message).addPropertyNode(propertyName).addConstraintViolation();
    }

    public void addViolation(String propertyName, Integer index, String message) {
        this.addViolation(propertyName, index, message, Collections.emptyMap());
    }

    public void addViolation(String propertyName, Integer index, String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        this.getContextWithMessageParameters(messageParameters).buildConstraintViolationWithTemplate(message).addPropertyNode(propertyName).addBeanNode().inIterable().atIndex(index).addConstraintViolation();
    }

    public void addViolation(String propertyName, String key, String message) {
        this.addViolation(propertyName, key, message, Collections.emptyMap());
    }

    public void addViolation(String propertyName, String key, String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        HibernateConstraintValidatorContext context = this.getContextWithMessageParameters(messageParameters);
        context.buildConstraintViolationWithTemplate(message).addPropertyNode(propertyName).addBeanNode().inIterable().atKey((Object)key).addConstraintViolation();
    }

    private HibernateConstraintValidatorContext getContextWithMessageParameters(Map<String, Object> messageParameters) {
        HibernateConstraintValidatorContext context = (HibernateConstraintValidatorContext)this.constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class);
        for (Map.Entry<String, Object> messageParameter : messageParameters.entrySet()) {
            Object value = messageParameter.getValue();
            String escapedValue = value == null ? null : InterpolationHelper.escapeMessageParameter(value.toString());
            context.addMessageParameter(messageParameter.getKey(), (Object)escapedValue);
        }
        return context;
    }

    public ConstraintValidatorContext getContext() {
        return this.constraintValidatorContext;
    }

    public boolean hasViolationOccurred() {
        return this.violationOccurred;
    }

    public void setViolationOccurred(boolean violationOccurred) {
        this.violationOccurred = violationOccurred;
    }
}

