/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-create", scope="fabric", description="Create a new version, copying all of the profiles from the current latest version into the new version")
public class VersionCreateAction
extends AbstractAction {
    @Option(name="--parent", description="The parent version. By default, use the latest version as the parent.")
    private String parentVersion;
    @Option(name="--default", description="Set the created version to be the new default version.")
    private Boolean defaultVersion;
    @Option(name="--description", description="The description notes of this version.")
    private String description;
    @Argument(index=0, description="The new version to create. If not specified, defaults to the next minor version.", required=false)
    private String name;
    private final FabricService fabricService;

    VersionCreateAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        Version created;
        Version parent;
        Version latestVersion = null;
        Version[] versions = this.getFabricService().getVersions();
        int vlength = versions.length;
        if (vlength > 0) {
            latestVersion = versions[vlength - 1];
        }
        if (this.name == null) {
            if (latestVersion == null) {
                throw new IllegalArgumentException("Cannot default the new version name as there are no versions available");
            }
            this.name = latestVersion.getSequence().next().getName();
        }
        if (this.parentVersion == null) {
            parent = latestVersion;
        } else {
            parent = this.getFabricService().getVersion(this.parentVersion);
            if (parent == null) {
                throw new IllegalArgumentException("Cannot find parent version: " + this.parentVersion);
            }
        }
        if (parent != null) {
            created = this.getFabricService().createVersion(parent, this.name);
            System.out.println("Created version: " + this.name + " as copy of: " + parent.getId());
        } else {
            created = this.getFabricService().createVersion(this.name);
            System.out.println("Created version: " + this.name);
        }
        if (this.defaultVersion != null && this.defaultVersion.booleanValue()) {
            this.getFabricService().setDefaultVersion(created);
        }
        if (this.description != null) {
            created.setAttribute("description", this.description);
        }
        return null;
    }
}

