/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-delete", scope="fabric", description="Delete the specified version, together with all of its associated profile data")
public class VersionDeleteAction
extends AbstractAction {
    @Argument(index=0, name="version", description="The version to delete", required=true, multiValued=false)
    private String versionName;
    private final FabricService fabricService;

    VersionDeleteAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        Version version = this.getFabricService().getVersion(this.versionName);
        if (version == null) {
            throw new IllegalArgumentException("Cannot find version: " + this.versionName);
        }
        StringBuilder sb = new StringBuilder();
        for (Container container : this.getFabricService().getContainers()) {
            if (!version.equals(container.getVersion())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(container.getId());
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException("Version " + this.versionName + " is still in used by the following containers: " + sb.toString());
        }
        version.delete();
        return null;
    }
}

