/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.commands.support.CommandUtils;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-info", scope="fabric", description="Displays information about a version")
public class VersionInfoAction
extends AbstractAction {
    static final String FORMAT = "%-30s %s";
    @Argument(index=0, name="version", description="The version name.", required=false, multiValued=false)
    private String versionName;
    private final FabricService fabricService;
    private final RuntimeProperties runtimeProperties;

    VersionInfoAction(FabricService fabricService, RuntimeProperties runtimeProperties) {
        this.fabricService = fabricService;
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        if (!this.versionExists(this.versionName)) {
            System.out.println("Container " + this.versionName + " does not exists!");
            return null;
        }
        Version version = this.fabricService.getVersion(this.versionName);
        String description = (String)version.getAttributes().get("description");
        StringBuilder sbContainers = new StringBuilder("");
        for (String c : this.fabricService.getDataStore().getContainers()) {
            if (!version.getId().equals(this.fabricService.getContainer(c).getVersion().getId())) continue;
            sbContainers.append(c);
            sbContainers.append(", ");
        }
        String containers = sbContainers.toString();
        if (containers.endsWith(", ")) {
            containers = containers.substring(0, containers.lastIndexOf(", "));
        }
        boolean defaultVersion = version.getId().equals(this.fabricService.getDefaultVersion().getId());
        Profile[] profiles = CommandUtils.sortProfiles(version.getProfiles());
        StringBuilder sbProfiles = new StringBuilder("");
        for (int i = 0; i < profiles.length; ++i) {
            if (i != 0) {
                sbProfiles.append(", ");
            }
            sbProfiles.append(profiles[i].getId());
        }
        System.out.println(String.format(FORMAT, "Name:", version.getId()));
        System.out.println(String.format(FORMAT, "Description:", description != null ? description : ""));
        System.out.println(String.format(FORMAT, "Default Version:", defaultVersion));
        System.out.println(String.format(FORMAT, "Containers:", containers));
        System.out.println(String.format(FORMAT, "Profiles:", sbProfiles.toString()));
        return null;
    }

    private boolean versionExists(String versionName) {
        Version[] versions;
        for (Version v : versions = this.fabricService.getVersions()) {
            if (!versionName.equals(v.getId())) continue;
            return true;
        }
        return false;
    }
}

