/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.DataStore;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jledit.ContentManager;

public class DatastoreContentManager
implements ContentManager {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final DataStore dataStore;

    public DatastoreContentManager(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public String load(String location) throws IOException {
        try {
            String[] parts = location.trim().split(" ");
            if (parts.length < 3) {
                throw new IllegalArgumentException("Invalid location:" + location);
            }
            String version = parts[1];
            String profile = parts[0];
            String resource = parts[2];
            String data = new String(this.dataStore.getFileConfiguration(version, profile, resource));
            return data != null ? data : "";
        }
        catch (Exception e) {
            throw new IOException("Failed to read data from zookeeper.", e);
        }
    }

    public boolean save(String content, String location) {
        try {
            String[] parts = location.trim().split(" ");
            if (parts.length < 3) {
                throw new IllegalArgumentException("Invalid location:" + location);
            }
            String profile = parts[0];
            String version = parts[1];
            String resource = parts[2];
            this.dataStore.setFileConfiguration(version, profile, resource, content.getBytes());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean save(String content, Charset charset, String location) {
        return this.save(content, location);
    }

    public Charset detectCharset(String location) {
        return UTF_8;
    }
}

