/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.scr.AbstractComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={PidCompleter.class, Completer.class})
public class PidCompleter
extends AbstractComponent
implements Completer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PidCompleter.class);
    private final StringsCompleter delegate = new StringsCompleter();
    @Reference
    private ConfigurationAdmin configurationAdmin;

    @Activate
    void activate() {
        Configuration[] configs;
        try {
            configs = this.configurationAdmin.listConfigurations(null);
            if (configs == null) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        ArrayList pids = new ArrayList();
        for (Configuration config : configs) {
            this.delegate.getStrings().addAll(this.getPidWithKeys(config.getPid()));
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public int complete(String buffer, int cursor, List candidates) {
        int firstPass = this.delegate.complete(buffer, cursor, candidates);
        if (firstPass < 0) {
            this.updateAllPids();
            return this.delegate.complete(buffer, cursor, candidates);
        }
        return firstPass;
    }

    private void updateAllPids() {
        Configuration[] configurations = null;
        try {
            configurations = this.configurationAdmin.listConfigurations(null);
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    this.delegate.getStrings().addAll(this.getPidWithKeys(configuration.getPid()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not lookup pids from configuration admin.");
        }
    }

    private Set<String> getPidWithKeys(String pid) {
        LinkedHashSet<String> pidWithKeys = new LinkedHashSet<String>();
        try {
            Dictionary dictionary;
            Configuration[] configuration = this.configurationAdmin.listConfigurations("(service.pid=" + pid + ")");
            if (configuration != null && configuration.length > 0 && (dictionary = configuration[0].getProperties()) != null) {
                Enumeration keyEnumeration = dictionary.keys();
                while (keyEnumeration.hasMoreElements()) {
                    String key = (String)keyEnumeration.nextElement();
                    pidWithKeys.add(pid + "/" + key);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not lookup pid {} from configuration admin.", (Object)pid);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.warn("Could not lookup pid {} from configuration admin.", (Object)pid);
        }
        return pidWithKeys;
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configurationAdmin == configurationAdmin) {
            this.configurationAdmin = null;
        }
    }
}

