/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.curator;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import io.fabric8.api.ManagedCuratorFrameworkAvailable;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import io.fabric8.zookeeper.curator.CuratorConfig;
import io.fabric8.zookeeper.curator.CuratorFrameworkLocator;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.zookeeper", label="Fabric8 ZooKeeper Client Factory", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={ManagedCuratorFrameworkAvailable.class})
@Properties(value={@Property(name="zookeeper.url", label="ZooKeeper URL", description="The URL to the ZooKeeper Server(s)", value={"${zookeeper.url}"}), @Property(name="zookeeper.password", label="ZooKeeper Password", description="The password used for ACL authentication", value={"${zookeeper.password}"}), @Property(name="retryPolicy.maxRetries", label="Maximum Retries Number", description="The number of retries on failed retry-able ZooKeeper operations", value={"${zookeeper.retry.max}"}), @Property(name="retryPolicy.retryIntervalMs", label="Retry Interval", description="The amount of time to wait between retries", value={"${zookeeper.retry.interval}"}), @Property(name="connectionTimeOutMs", label="Connection Timeout", description="The amount of time to wait in ms for connection", value={"${zookeeper.connection.timeout}"}), @Property(name="sessionTimeOutMs", label="Session Timeout", description="The amount of time to wait before timing out the session", value={"${zookeeper.session.timeout}"})})
public final class ManagedCuratorFramework
extends AbstractComponent
implements ManagedCuratorFrameworkAvailable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedCuratorFramework.class);
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=ACLProvider.class)
    private final ValidatingReference<ACLProvider> aclProvider = new ValidatingReference();
    @Reference(referenceInterface=ConnectionStateListener.class, bind="bindConnectionStateListener", unbind="unbindConnectionStateListener", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<ConnectionStateListener> connectionStateListeners = new CopyOnWriteArrayList<ConnectionStateListener>();
    @Reference(referenceInterface=BootstrapConfiguration.class)
    private final ValidatingReference<BootstrapConfiguration> bootstrapConfiguration = new ValidatingReference();
    private BundleContext bundleContext;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private AtomicReference<State> state = new AtomicReference();

    @Activate
    void activate(BundleContext bundleContext, Map<String, ?> configuration) throws Exception {
        State next;
        this.bundleContext = bundleContext;
        CuratorConfig config = new CuratorConfig();
        this.configurer.configure(configuration, (Object)config);
        if (!Strings.isNullOrEmpty((String)config.getZookeeperUrl()) && this.state.compareAndSet(null, next = new State(config))) {
            this.executor.submit(next);
        }
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        CuratorConfig config = new CuratorConfig();
        this.configurer.configure(configuration, (Object)this);
        this.configurer.configure(configuration, (Object)config);
        if (!Strings.isNullOrEmpty((String)config.getZookeeperUrl())) {
            CuratorConfig oldConfiguration;
            State prev = this.state.get();
            CuratorConfig curatorConfig = oldConfiguration = prev != null ? prev.configuration : null;
            if (!config.equals(oldConfiguration)) {
                State next = new State(config);
                if (this.state.compareAndSet(prev, next)) {
                    this.executor.submit(next);
                    if (prev != null) {
                        prev.close();
                    }
                } else {
                    next.close();
                }
            }
        }
    }

    @Deactivate
    void deactivate() throws IOException {
        this.deactivateComponent();
        State prev = this.state.getAndSet(null);
        if (prev != null) {
            CuratorFrameworkLocator.unbindCurator(prev.curator);
            prev.close();
        }
        this.executor.shutdownNow();
    }

    private synchronized CuratorFramework buildCuratorFramework(CuratorConfig curatorConfig) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().ensembleProvider(new FixedEnsembleProvider(curatorConfig.getZookeeperUrl())).connectionTimeoutMs(curatorConfig.getZookeeperConnectionTimeOut()).sessionTimeoutMs(curatorConfig.getZookeeperSessionTimeout()).retryPolicy(new RetryNTimes(curatorConfig.getZookeeperRetryMax(), curatorConfig.getZookeeperRetryInterval()));
        if (!Strings.isNullOrEmpty((String)curatorConfig.getZookeeperPassword())) {
            String scheme = "digest";
            byte[] auth = ("fabric:" + PasswordEncoder.decode(curatorConfig.getZookeeperPassword())).getBytes();
            builder = builder.authorization(scheme, auth).aclProvider((ACLProvider)this.aclProvider.get());
        }
        CuratorFramework framework = builder.build();
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            framework.getConnectionStateListenable().addListener(listener);
        }
        return framework;
    }

    void bindConnectionStateListener(ConnectionStateListener connectionStateListener) {
        CuratorFramework curator;
        this.connectionStateListeners.add(connectionStateListener);
        State curr = this.state.get();
        CuratorFramework curatorFramework = curator = curr != null ? curr.curator : null;
        if (curator != null && curator.getZookeeperClient().isConnected()) {
            connectionStateListener.stateChanged(curator, ConnectionState.CONNECTED);
        }
    }

    void unbindConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListeners.remove(connectionStateListener);
    }

    void bindAclProvider(ACLProvider aclProvider) {
        this.aclProvider.bind((Object)aclProvider);
    }

    void unbindAclProvider(ACLProvider aclProvider) {
        this.aclProvider.unbind((Object)aclProvider);
    }

    void bindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.bind((Object)service);
    }

    void unbindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.unbind((Object)service);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }

    class State
    implements ConnectionStateListener,
    Runnable {
        final CuratorConfig configuration;
        final AtomicBoolean closed = new AtomicBoolean();
        ServiceRegistration<CuratorFramework> registration;
        CuratorFramework curator;

        State(CuratorConfig configuration) {
            this.configuration = configuration;
        }

        @Override
        public void run() {
            try {
                if (this.curator != null) {
                    this.curator.getZookeeperClient().stop();
                }
                if (this.registration != null) {
                    this.registration.unregister();
                    this.registration = null;
                }
                try {
                    Closeables.close((Closeable)this.curator, (boolean)true);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.curator = null;
                if (!this.closed.get()) {
                    this.curator = ManagedCuratorFramework.this.buildCuratorFramework(this.configuration);
                    this.curator.getConnectionStateListenable().addListener(this, ManagedCuratorFramework.this.executor);
                    this.curator.start();
                    CuratorFrameworkLocator.bindCurator(this.curator);
                }
            }
            catch (Throwable th) {
                LOGGER.error("Cannot start curator framework", th);
            }
        }

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.CONNECTED && this.registration == null) {
                this.registration = ManagedCuratorFramework.this.bundleContext.registerService(CuratorFramework.class, (Object)this.curator, null);
            }
            for (ConnectionStateListener listener : ManagedCuratorFramework.this.connectionStateListeners) {
                listener.stateChanged(client, newState);
            }
            if (newState == ConnectionState.LOST) {
                this.run();
            }
        }

        public void close() {
            this.closed.set(true);
            CuratorFramework curator = this.curator;
            if (curator != null) {
                curator.getZookeeperClient().stop();
            }
            try {
                ManagedCuratorFramework.this.executor.submit(this).get();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing curator", (Throwable)e);
            }
        }
    }
}

