/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.archetype;

import com.google.common.base.Objects;
import io.fabric8.forge.addon.utils.VersionHelper;
import io.fabric8.forge.camel.commands.project.archetype.FabricArchetypeCatalogFactory;
import io.fabric8.utils.Strings;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.archetype.catalog.Archetype;
import org.jboss.forge.addon.maven.projects.archetype.ui.ConstantArchetypeSelectionWizardStep;

public abstract class Fabric8ArchetypeCatalogStep
extends ConstantArchetypeSelectionWizardStep {
    @Inject
    private FabricArchetypeCatalogFactory catalogFactory;

    public Fabric8ArchetypeCatalogStep() {
        this.setArchetypeGroupId("io.fabric8.archetypes");
    }

    protected void setArchetypeArtifactId(String archetypeArtifactId) {
        super.setArchetypeArtifactId(archetypeArtifactId);
        if (Strings.isNotBlank((String)archetypeArtifactId) && Strings.isNullOrBlank((String)this.getArchetypeVersion())) {
            String version = null;
            if (this.catalogFactory != null) {
                List archetypes = this.catalogFactory.getArchetypeCatalog().getArchetypes();
                for (Archetype archetype : archetypes) {
                    if (!Objects.equal((Object)archetype.getArtifactId(), (Object)archetypeArtifactId)) continue;
                    version = archetype.getVersion();
                }
            }
            if (Strings.isNullOrBlank(version)) {
                version = VersionHelper.fabric8ArchetypesVersion();
            }
            if (version != null) {
                this.setArchetypeVersion(version);
            } else {
                throw new IllegalArgumentException("Could not find an archetype for id " + archetypeArtifactId + " in the archetype catalog " + this.catalogFactory + " or find version for environment variable " + "FABRIC8_ARCHETYPES_VERSION");
            }
        }
    }
}

