/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.eshead;

import io.fabric8.insight.elasticsearch.ElasticRest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

/*
 * Exception performing whole class analysis ignored.
 */
public class ElasticSearchServlet
extends HttpServlet {
    private ServiceTracker<ElasticRest, ElasticRest> tracker;

    public void init() throws ServletException {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.tracker = new ServiceTracker(context, ElasticRest.class, null);
        this.tracker.open();
    }

    public void destroy() {
        try {
            this.tracker.close();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        String uri = req.getPathInfo();
        String content = ElasticSearchServlet.loadFully((InputStream)req.getInputStream(), (String)req.getCharacterEncoding());
        try {
            ElasticRest rest = (ElasticRest)this.tracker.getService();
            if (rest != null) {
                String result;
                if ("GET".equals(method)) {
                    result = rest.get(uri);
                } else if ("POST".equals(method)) {
                    result = rest.post(uri, content);
                } else if ("PUT".equals(method)) {
                    result = rest.put(uri, content);
                } else if ("DELETE".equals(method)) {
                    result = rest.delete(uri);
                } else if ("HEAD".equals(method)) {
                    result = rest.head(uri);
                } else {
                    resp.sendError(501, "Unknown method " + method);
                    return;
                }
                resp.getWriter().write(result);
            } else {
                resp.sendError(500, "ElasticSearch service not available");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFully(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int l;
            while ((l = is.read(buf)) >= 0) {
                baos.write(buf, 0, l);
            }
        }
        finally {
            is.close();
        }
        return encoding != null ? baos.toString(encoding) : baos.toString();
    }
}

