/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers.batch.v1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.kubernetes.client.dsl.internal.batch.v1.JobOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class JobHandler
implements ResourceHandler<Job, JobBuilder> {
    @Override
    public String getKind() {
        return Job.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "batch/v1";
    }

    @Override
    public Job create(OkHttpClient client, Config config, String namespace, Job item, boolean dryRun) {
        return (Job)((WritableOperation)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Job[0]);
    }

    @Override
    public Job replace(OkHttpClient client, Config config, String namespace, Job item, boolean dryRun) {
        return ((WritableOperation)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Job reload(OkHttpClient client, Config config, String namespace, Job item) {
        return (Job)((Gettable)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public JobBuilder edit(Job item) {
        return new JobBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Job item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new JobOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Job item, Watcher<Job> watcher) {
        return ((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Job item, String resourceVersion, Watcher<Job> watcher) {
        return ((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Job item, ListOptions options, Watcher<Job> watcher) {
        return ((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Job waitUntilReady(OkHttpClient client, Config config, String namespace, Job item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Job)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Job waitUntilCondition(OkHttpClient client, Config config, String namespace, Job item, Predicate<Job> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Job)((ScalableResource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

