/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollableScalableResourceOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends HasMetadataOperation<T, L, R>
implements RollableScalableResource<T>,
TimeoutImageEditReplacePatchable<T> {
    private static final Logger Log = LoggerFactory.getLogger(RollableScalableResourceOperation.class);
    protected final PodOperationContext rollingOperationContext;

    protected RollableScalableResourceOperation(PodOperationContext context, OperationContext superContext, Class<T> type, Class<L> listType) {
        super(superContext, type, listType);
        this.rollingOperationContext = context;
    }

    protected abstract T withReplicas(int var1);

    protected abstract RollingUpdater<T, L> getRollingUpdater(long var1, TimeUnit var3);

    protected abstract int getCurrentReplicas(T var1);

    protected abstract int getDesiredReplicas(T var1);

    protected abstract long getObservedGeneration(T var1);

    public T scale(int count) {
        return this.scale(count, false);
    }

    public T scale(int count, boolean wait) {
        T res = this.withReplicas(count);
        if (wait) {
            return this.waitUntilScaled(count);
        }
        return res;
    }

    public Scale scale() {
        return this.handleScale(null);
    }

    public Scale scale(Scale scaleParam) {
        return this.handleScale(scaleParam);
    }

    private T waitUntilScaled(int count) {
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        try {
            return (T)this.waitUntilCondition((T t) -> {
                if (t == null) {
                    if (count == 0) {
                        return true;
                    }
                    throw new IllegalStateException("Can't wait for " + this.getType().getSimpleName() + ": " + name + " in namespace: " + namespace + " to scale. Resource is no longer available.");
                }
                int currentReplicas = this.getCurrentReplicas(t);
                int desiredReplicas = this.getDesiredReplicas(t);
                replicasRef.set(currentReplicas);
                long generation = t.getMetadata().getGeneration() != null ? t.getMetadata().getGeneration() : -1L;
                long observedGeneration = this.getObservedGeneration(t);
                if (observedGeneration >= generation && Objects.equals(desiredReplicas, currentReplicas)) {
                    return true;
                }
                Log.debug("Only {}/{} replicas scheduled for {}: {} in namespace: {} seconds so waiting...", new Object[]{currentReplicas, desiredReplicas, t.getKind(), t.getMetadata().getName(), namespace});
                return false;
            }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (KubernetesClientTimeoutException e) {
            throw new KubernetesClientException(String.format("%s/%s pod(s) ready for %s: %s in namespace: %s  after waiting for %s seconds so giving up", replicasRef.get(), count, this.getType().getSimpleName(), name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())), (Throwable)e);
        }
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        if (!this.rollingOperationContext.isRolling()) {
            return super.edit(function);
        }
        try {
            Object oldObj = this.getMandatory();
            HasMetadata newObj = (HasMetadata)function.apply(Serialization.clone(oldObj));
            return (T)this.getRollingUpdater(this.context.getTimeout(), this.context.getTimeoutUnit()).rollUpdate((HasMetadata)oldObj, newObj);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public T replace(T t) {
        if (!this.rollingOperationContext.isRolling()) {
            return super.replace(t);
        }
        return this.getRollingUpdater(this.context.getTimeout(), this.context.getTimeoutUnit()).rollUpdate(this.getMandatory(), t);
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        if (!this.rollingOperationContext.isRolling() || patchContext == null || patchContext.getPatchType() != PatchType.JSON) {
            return super.patch(patchContext, item);
        }
        return this.getRollingUpdater(this.context.getTimeout(), this.context.getTimeoutUnit()).rollUpdate(this.getMandatory(), item);
    }

    public abstract RollableScalableResourceOperation<T, L, R> newInstance(PodOperationContext var1, OperationContext var2);

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return this.newInstance(this.rollingOperationContext.withLogWaitTimeout(logWaitTimeout), this.context);
    }

    public Loggable inContainer(String id) {
        return this.newInstance(this.rollingOperationContext.withContainerId(id), this.context);
    }

    public TimeoutImageEditReplacePatchable<T> rolling() {
        return this.newInstance(this.rollingOperationContext.toBuilder().rolling(true).build(), this.context);
    }

    public String getLog() {
        return this.getLog(this.rollingOperationContext.isPrettyOutput());
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public T updateImage(String image) {
        Object value = this.get();
        if (value == null) {
            throw new KubernetesClientException("Resource doesn't exist");
        }
        List<Container> containers = this.getContainers(value);
        if (containers.size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (containers.isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = containers.iterator().next();
        return this.updateImage(Collections.singletonMap(container.getName(), image));
    }

    protected abstract List<Container> getContainers(T var1);

    public T updateImage(Map<String, String> containerToImageMap) {
        Object value = this.get();
        if (value == null) {
            throw new KubernetesClientException("Resource doesn't exist");
        }
        HasMetadata base = (HasMetadata)Serialization.clone(value);
        List<Container> containers = this.getContainers(value);
        if (containers.isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        return (T)this.sendPatchedObject(base, value);
    }

    protected T sendPatchedObject(T oldObject, T updatedObject) {
        return this.patch(null, oldObject, updatedObject, false);
    }

    @Override
    public RollableScalableResourceOperation<T, L, R> withTimeout(long timeout, TimeUnit unit) {
        return this.newInstance(this.rollingOperationContext, this.context.withTimeout(timeout, unit));
    }

    public RollableScalableResourceOperation<T, L, R> withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }
}

