/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListExamples {
    private static final Logger logger = LoggerFactory.getLogger(ListExamples.class);

    public static void main(String[] args) {
        String master = "https://192.168.42.20:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            System.out.println(client.namespaces().list());
            System.out.println(((FilterWatchListDeletable)client.namespaces().withLabel("this", "works")).list());
            System.out.println(((FilterWatchListDeletable)client.pods().withLabel("this", "works")).list());
            System.out.println(((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace("test")).withLabel("this", "works")).list());
            System.out.println(((PodResource)((NonNamespaceOperation)client.pods().inNamespace("test")).withName("testing")).get());
            PodList podList = (PodList)((NonNamespaceOperation)client.pods().inNamespace("myproject")).list(Integer.valueOf(5), null);
            podList.getItems().forEach(obj -> System.out.println(obj.getMetadata().getName()));
            podList = (PodList)((NonNamespaceOperation)client.pods().inNamespace("myproject")).list(Integer.valueOf(5), podList.getMetadata().getContinue());
            podList.getItems().forEach(obj -> System.out.println(obj.getMetadata().getName()));
            Integer services = ((ServiceList)((NonNamespaceOperation)client.services().inNamespace("myproject")).list(Integer.valueOf(1), null)).getItems().size();
            ((NonNamespaceOperation)client.services().inNamespace("myproject")).list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(1L))).withContinue(null)).build());
            System.out.println(services);
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

