package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControllerRevisionListBuilder extends ControllerRevisionListFluentImpl<ControllerRevisionListBuilder> implements VisitableBuilder<ControllerRevisionList,ControllerRevisionListBuilder>{
  public ControllerRevisionListBuilder() {
    this(false);
  }
  public ControllerRevisionListBuilder(Boolean validationEnabled) {
    this(new ControllerRevisionList(), validationEnabled);
  }
  public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent) {
    this(fluent, false);
  }
  public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControllerRevisionList(), validationEnabled);
  }
  public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent,ControllerRevisionList instance) {
    this(fluent, instance, false);
  }
  public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent,ControllerRevisionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ControllerRevisionListBuilder(ControllerRevisionList instance) {
    this(instance,false);
  }
  public ControllerRevisionListBuilder(ControllerRevisionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ControllerRevisionListFluent<?> fluent;
  Boolean validationEnabled;
  public ControllerRevisionList build() {
    ControllerRevisionList buildable = new ControllerRevisionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}