package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetStatusBuilder extends StatefulSetStatusFluentImpl<StatefulSetStatusBuilder> implements VisitableBuilder<StatefulSetStatus,StatefulSetStatusBuilder>{
  public StatefulSetStatusBuilder() {
    this(false);
  }
  public StatefulSetStatusBuilder(Boolean validationEnabled) {
    this(new StatefulSetStatus(), validationEnabled);
  }
  public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetStatus(), validationEnabled);
  }
  public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent,StatefulSetStatus instance) {
    this(fluent, instance, false);
  }
  public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent,StatefulSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withCollisionCount(instance.getCollisionCount());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentReplicas(instance.getCurrentReplicas());
      fluent.withCurrentRevision(instance.getCurrentRevision());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withUpdateRevision(instance.getUpdateRevision());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetStatusBuilder(StatefulSetStatus instance) {
    this(instance,false);
  }
  public StatefulSetStatusBuilder(StatefulSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withCollisionCount(instance.getCollisionCount());
      this.withConditions(instance.getConditions());
      this.withCurrentReplicas(instance.getCurrentReplicas());
      this.withCurrentRevision(instance.getCurrentRevision());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withUpdateRevision(instance.getUpdateRevision());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatefulSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetStatus build() {
    StatefulSetStatus buildable = new StatefulSetStatus(fluent.getAvailableReplicas(),fluent.getCollisionCount(),fluent.getConditions(),fluent.getCurrentReplicas(),fluent.getCurrentRevision(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas(),fluent.getUpdateRevision(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}