/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq;

import io.fabric8.mq.ActiveMQService;
import io.fabric8.mq.ConsumerThread;
import io.fabric8.mq.ProducerThread;
import java.util.Arrays;
import java.util.LinkedList;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;

public class Main {
    static final String loggingLevelProperty = "org.ops4j.pax.logging.DefaultServiceLog.level";
    String action;
    String destination;
    String brokerUrl = ActiveMQConnectionFactory.DEFAULT_BROKER_URL;
    boolean persistent = true;
    int count = 100;
    int sleep = 0;
    int size = 0;
    String clientId;
    String password;
    String user;
    int batchSize;

    public static void main(String[] args) throws Exception {
        if (System.getProperty(loggingLevelProperty) == null) {
            System.setProperty(loggingLevelProperty, "INFO");
        }
        Main main = new Main();
        LinkedList<String> arg1 = new LinkedList<String>(Arrays.asList(args));
        main.action = Main.shift(arg1);
        while (!arg1.isEmpty()) {
            try {
                String arg = arg1.removeFirst();
                if ("--size".equals(arg)) {
                    main.size = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--count".equals(arg)) {
                    main.count = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--sleep".equals(arg)) {
                    main.sleep = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--destination".equals(arg)) {
                    main.destination = Main.shift(arg1);
                    continue;
                }
                if ("--brokerUrl".equals(arg)) {
                    main.brokerUrl = Main.shift(arg1);
                    continue;
                }
                if ("--user".equals(arg)) {
                    main.user = Main.shift(arg1);
                    continue;
                }
                if ("--password".equals(arg)) {
                    main.password = Main.shift(arg1);
                    continue;
                }
                if ("--clientId".equals(arg)) {
                    main.clientId = Main.shift(arg1);
                    continue;
                }
                if ("--batchSize".equals(arg)) {
                    main.batchSize = Integer.parseInt(Main.shift(arg1));
                    continue;
                }
                if ("--persistent".equals(arg)) {
                    main.persistent = Boolean.valueOf(Main.shift(arg1));
                    continue;
                }
                System.err.println("Invalid usage: unknown option: " + arg);
                Main.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid usage: argument not a number");
                Main.displayHelpAndExit(1);
            }
        }
        main.execute();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        this.initDestination();
        System.out.println("Using destination: " + this.destination + ", on broker: " + this.brokerUrl);
        ActiveMQService activeMQService = new ActiveMQService(this.user, this.password, this.brokerUrl);
        activeMQService.setTransacted(this.batchSize > 0);
        try {
            if ("producer".equals(this.action)) {
                activeMQService.start();
                ProducerThread producerThread = new ProducerThread(activeMQService, this.destination);
                producerThread.setMessageCount(this.count);
                producerThread.setMessageSize(this.size);
                producerThread.setSleep(this.sleep);
                producerThread.setPersistent(this.persistent);
                producerThread.setTransactionBatchSize(this.batchSize);
                producerThread.run();
                System.out.println("Produced: " + producerThread.getSentCount());
            } else if ("consumer".equals(this.action)) {
                activeMQService.setClientId(this.clientId);
                activeMQService.start();
                ConsumerThread consumerThread = new ConsumerThread(activeMQService, this.destination);
                consumerThread.setMessageCount(this.count);
                consumerThread.setSleep(this.sleep);
                consumerThread.setTransactionBatchSize(this.batchSize);
                System.out.println("Waiting for: " + this.count + " messages");
                consumerThread.run();
                System.out.println("Consumed: " + consumerThread.getReceived() + " messages");
            } else {
                Main.displayHelpAndExit(1);
            }
        }
        catch (JMSException error) {
            System.err.println("Execution failed with: " + (Object)((Object)error));
            error.printStackTrace(System.err);
            System.exit(2);
        }
        finally {
            activeMQService.stop();
        }
    }

    private void initDestination() {
        if (this.destination == null) {
            this.destination = this.clientId != null ? "topic://TEST" : "queue://TEST";
        }
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            System.out.println("Invalid usage: Missing argument");
            Main.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    private static void displayHelpAndExit(int exitCode) {
        System.out.println(" usage   : (producer|consumer) [OPTIONS]");
        System.out.println(" options : [--destination (queue://..|topic://..) - ; default TEST");
        System.out.println("           [--persistent  true|false] - use persistent or non persistent messages; default true");
        System.out.println("           [--count       N] - number of messages to send or receive; default 100");
        System.out.println("           [--size        N] - size in bytes of a BytesMessage; default 0, a simple TextMessage is used");
        System.out.println("           [--sleep       N] - millisecond sleep period between sends or receives; default 0");
        System.out.println("           [--batchSize   N] - use send and receive transaction batches of size N; default 0, no jms transactions");
        System.out.println("           [--clientId   id] - use a durable topic consumer with the supplied id; default null, non durable consumer");
        System.out.println("           [--brokerUrl URL] - connection factory url; default " + ActiveMQConnectionFactory.DEFAULT_BROKER_URL);
        System.out.println("           [--user      .. ] - connection user name");
        System.out.println("           [--password  .. ] - connection password");
        System.out.println("");
        System.exit(exitCode);
    }
}

