package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildTriggerPolicyFluent<A extends BuildTriggerPolicyFluent<A>> extends BaseFluent<A>{
  public BuildTriggerPolicyFluent() {
  }
  
  public BuildTriggerPolicyFluent(BuildTriggerPolicy instance) {
    this.copyInstance(instance);
  }
  private WebHookTriggerBuilder bitbucket;
  private WebHookTriggerBuilder generic;
  private WebHookTriggerBuilder github;
  private WebHookTriggerBuilder gitlab;
  private ImageChangeTriggerBuilder imageChange;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildTriggerPolicy instance) {
    instance = (instance != null ? instance : new BuildTriggerPolicy());
    if (instance != null) {
          this.withBitbucket(instance.getBitbucket());
          this.withGeneric(instance.getGeneric());
          this.withGithub(instance.getGithub());
          this.withGitlab(instance.getGitlab());
          this.withImageChange(instance.getImageChange());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public WebHookTrigger buildBitbucket() {
    return this.bitbucket != null ? this.bitbucket.build() : null;
  }
  
  public A withBitbucket(WebHookTrigger bitbucket) {
    this._visitables.remove("bitbucket");
    if (bitbucket != null) {
        this.bitbucket = new WebHookTriggerBuilder(bitbucket);
        this._visitables.get("bitbucket").add(this.bitbucket);
    } else {
        this.bitbucket = null;
        this._visitables.get("bitbucket").remove(this.bitbucket);
    }
    return (A) this;
  }
  
  public boolean hasBitbucket() {
    return this.bitbucket != null;
  }
  
  public BitbucketNested<A> withNewBitbucket() {
    return new BitbucketNested(null);
  }
  
  public BitbucketNested<A> withNewBitbucketLike(WebHookTrigger item) {
    return new BitbucketNested(item);
  }
  
  public BitbucketNested<A> editBitbucket() {
    return withNewBitbucketLike(java.util.Optional.ofNullable(buildBitbucket()).orElse(null));
  }
  
  public BitbucketNested<A> editOrNewBitbucket() {
    return withNewBitbucketLike(java.util.Optional.ofNullable(buildBitbucket()).orElse(new WebHookTriggerBuilder().build()));
  }
  
  public BitbucketNested<A> editOrNewBitbucketLike(WebHookTrigger item) {
    return withNewBitbucketLike(java.util.Optional.ofNullable(buildBitbucket()).orElse(item));
  }
  
  public WebHookTrigger buildGeneric() {
    return this.generic != null ? this.generic.build() : null;
  }
  
  public A withGeneric(WebHookTrigger generic) {
    this._visitables.remove("generic");
    if (generic != null) {
        this.generic = new WebHookTriggerBuilder(generic);
        this._visitables.get("generic").add(this.generic);
    } else {
        this.generic = null;
        this._visitables.get("generic").remove(this.generic);
    }
    return (A) this;
  }
  
  public boolean hasGeneric() {
    return this.generic != null;
  }
  
  public GenericNested<A> withNewGeneric() {
    return new GenericNested(null);
  }
  
  public GenericNested<A> withNewGenericLike(WebHookTrigger item) {
    return new GenericNested(item);
  }
  
  public GenericNested<A> editGeneric() {
    return withNewGenericLike(java.util.Optional.ofNullable(buildGeneric()).orElse(null));
  }
  
  public GenericNested<A> editOrNewGeneric() {
    return withNewGenericLike(java.util.Optional.ofNullable(buildGeneric()).orElse(new WebHookTriggerBuilder().build()));
  }
  
  public GenericNested<A> editOrNewGenericLike(WebHookTrigger item) {
    return withNewGenericLike(java.util.Optional.ofNullable(buildGeneric()).orElse(item));
  }
  
  public WebHookTrigger buildGithub() {
    return this.github != null ? this.github.build() : null;
  }
  
  public A withGithub(WebHookTrigger github) {
    this._visitables.remove("github");
    if (github != null) {
        this.github = new WebHookTriggerBuilder(github);
        this._visitables.get("github").add(this.github);
    } else {
        this.github = null;
        this._visitables.get("github").remove(this.github);
    }
    return (A) this;
  }
  
  public boolean hasGithub() {
    return this.github != null;
  }
  
  public GithubNested<A> withNewGithub() {
    return new GithubNested(null);
  }
  
  public GithubNested<A> withNewGithubLike(WebHookTrigger item) {
    return new GithubNested(item);
  }
  
  public GithubNested<A> editGithub() {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(null));
  }
  
  public GithubNested<A> editOrNewGithub() {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(new WebHookTriggerBuilder().build()));
  }
  
  public GithubNested<A> editOrNewGithubLike(WebHookTrigger item) {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(item));
  }
  
  public WebHookTrigger buildGitlab() {
    return this.gitlab != null ? this.gitlab.build() : null;
  }
  
  public A withGitlab(WebHookTrigger gitlab) {
    this._visitables.remove("gitlab");
    if (gitlab != null) {
        this.gitlab = new WebHookTriggerBuilder(gitlab);
        this._visitables.get("gitlab").add(this.gitlab);
    } else {
        this.gitlab = null;
        this._visitables.get("gitlab").remove(this.gitlab);
    }
    return (A) this;
  }
  
  public boolean hasGitlab() {
    return this.gitlab != null;
  }
  
  public GitlabNested<A> withNewGitlab() {
    return new GitlabNested(null);
  }
  
  public GitlabNested<A> withNewGitlabLike(WebHookTrigger item) {
    return new GitlabNested(item);
  }
  
  public GitlabNested<A> editGitlab() {
    return withNewGitlabLike(java.util.Optional.ofNullable(buildGitlab()).orElse(null));
  }
  
  public GitlabNested<A> editOrNewGitlab() {
    return withNewGitlabLike(java.util.Optional.ofNullable(buildGitlab()).orElse(new WebHookTriggerBuilder().build()));
  }
  
  public GitlabNested<A> editOrNewGitlabLike(WebHookTrigger item) {
    return withNewGitlabLike(java.util.Optional.ofNullable(buildGitlab()).orElse(item));
  }
  
  public ImageChangeTrigger buildImageChange() {
    return this.imageChange != null ? this.imageChange.build() : null;
  }
  
  public A withImageChange(ImageChangeTrigger imageChange) {
    this._visitables.remove("imageChange");
    if (imageChange != null) {
        this.imageChange = new ImageChangeTriggerBuilder(imageChange);
        this._visitables.get("imageChange").add(this.imageChange);
    } else {
        this.imageChange = null;
        this._visitables.get("imageChange").remove(this.imageChange);
    }
    return (A) this;
  }
  
  public boolean hasImageChange() {
    return this.imageChange != null;
  }
  
  public ImageChangeNested<A> withNewImageChange() {
    return new ImageChangeNested(null);
  }
  
  public ImageChangeNested<A> withNewImageChangeLike(ImageChangeTrigger item) {
    return new ImageChangeNested(item);
  }
  
  public ImageChangeNested<A> editImageChange() {
    return withNewImageChangeLike(java.util.Optional.ofNullable(buildImageChange()).orElse(null));
  }
  
  public ImageChangeNested<A> editOrNewImageChange() {
    return withNewImageChangeLike(java.util.Optional.ofNullable(buildImageChange()).orElse(new ImageChangeTriggerBuilder().build()));
  }
  
  public ImageChangeNested<A> editOrNewImageChangeLike(ImageChangeTrigger item) {
    return withNewImageChangeLike(java.util.Optional.ofNullable(buildImageChange()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildTriggerPolicyFluent that = (BuildTriggerPolicyFluent) o;
    if (!java.util.Objects.equals(bitbucket, that.bitbucket)) return false;
    if (!java.util.Objects.equals(generic, that.generic)) return false;
    if (!java.util.Objects.equals(github, that.github)) return false;
    if (!java.util.Objects.equals(gitlab, that.gitlab)) return false;
    if (!java.util.Objects.equals(imageChange, that.imageChange)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bitbucket,  generic,  github,  gitlab,  imageChange,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bitbucket != null) { sb.append("bitbucket:"); sb.append(bitbucket + ","); }
    if (generic != null) { sb.append("generic:"); sb.append(generic + ","); }
    if (github != null) { sb.append("github:"); sb.append(github + ","); }
    if (gitlab != null) { sb.append("gitlab:"); sb.append(gitlab + ","); }
    if (imageChange != null) { sb.append("imageChange:"); sb.append(imageChange + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BitbucketNested<N> extends WebHookTriggerFluent<BitbucketNested<N>> implements Nested<N>{
    BitbucketNested(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerBuilder builder;
    
    public N and() {
      return (N) BuildTriggerPolicyFluent.this.withBitbucket(builder.build());
    }
    
    public N endBitbucket() {
      return and();
    }
    
  
  }
  public class GenericNested<N> extends WebHookTriggerFluent<GenericNested<N>> implements Nested<N>{
    GenericNested(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerBuilder builder;
    
    public N and() {
      return (N) BuildTriggerPolicyFluent.this.withGeneric(builder.build());
    }
    
    public N endGeneric() {
      return and();
    }
    
  
  }
  public class GithubNested<N> extends WebHookTriggerFluent<GithubNested<N>> implements Nested<N>{
    GithubNested(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerBuilder builder;
    
    public N and() {
      return (N) BuildTriggerPolicyFluent.this.withGithub(builder.build());
    }
    
    public N endGithub() {
      return and();
    }
    
  
  }
  public class GitlabNested<N> extends WebHookTriggerFluent<GitlabNested<N>> implements Nested<N>{
    GitlabNested(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerBuilder builder;
    
    public N and() {
      return (N) BuildTriggerPolicyFluent.this.withGitlab(builder.build());
    }
    
    public N endGitlab() {
      return and();
    }
    
  
  }
  public class ImageChangeNested<N> extends ImageChangeTriggerFluent<ImageChangeNested<N>> implements Nested<N>{
    ImageChangeNested(ImageChangeTrigger item) {
      this.builder = new ImageChangeTriggerBuilder(this, item);
    }
    ImageChangeTriggerBuilder builder;
    
    public N and() {
      return (N) BuildTriggerPolicyFluent.this.withImageChange(builder.build());
    }
    
    public N endImageChange() {
      return and();
    }
    
  
  }

}