package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TagEventBuilder extends TagEventFluent<TagEventBuilder> implements VisitableBuilder<TagEvent,TagEventBuilder>{
  public TagEventBuilder() {
    this(new TagEvent());
  }
  
  public TagEventBuilder(TagEventFluent<?> fluent) {
    this(fluent, new TagEvent());
  }
  
  public TagEventBuilder(TagEventFluent<?> fluent,TagEvent instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TagEventBuilder(TagEvent instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TagEventFluent<?> fluent;
  
  public TagEvent build() {
    TagEvent buildable = new TagEvent(fluent.getCreated(),fluent.getDockerImageReference(),fluent.getGeneration(),fluent.getImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}