package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class UserBuilder extends UserFluent<UserBuilder> implements VisitableBuilder<User,UserBuilder>{
  public UserBuilder() {
    this(new User());
  }
  
  public UserBuilder(UserFluent<?> fluent) {
    this(fluent, new User());
  }
  
  public UserBuilder(UserFluent<?> fluent,User instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public UserBuilder(User instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  UserFluent<?> fluent;
  
  public User build() {
    User buildable = new User(fluent.getApiVersion(),fluent.getFullName(),fluent.getGroups(),fluent.getIdentities(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}