/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.ConfigKeys$charting$;
import io.gatling.core.ConfigKeys$charting$indicators$;
import io.gatling.core.ConfigKeys$core$;
import io.gatling.core.ConfigKeys$core$directory$;
import io.gatling.core.ConfigKeys$core$extract$css$;
import io.gatling.core.ConfigKeys$core$extract$jsonPath$;
import io.gatling.core.ConfigKeys$core$extract$jsonPath$jackson$;
import io.gatling.core.ConfigKeys$core$extract$regex$;
import io.gatling.core.ConfigKeys$core$extract$xpath$;
import io.gatling.core.ConfigKeys$core$timeOut$;
import io.gatling.core.ConfigKeys$core$zinc$;
import io.gatling.core.ConfigKeys$data$;
import io.gatling.core.ConfigKeys$data$console$;
import io.gatling.core.ConfigKeys$data$file$;
import io.gatling.core.ConfigKeys$data$graphite$;
import io.gatling.core.ConfigKeys$data$jdbc$;
import io.gatling.core.ConfigKeys$data$jdbc$create$;
import io.gatling.core.ConfigKeys$data$jdbc$insert$;
import io.gatling.core.ConfigKeys$http$;
import io.gatling.core.ConfigKeys$http$ahc$;
import io.gatling.core.ConfigKeys$http$ssl$keyStore$;
import io.gatling.core.ConfigKeys$http$ssl$trustStore$;
import io.gatling.core.config.AHCConfiguration;
import io.gatling.core.config.ChartingConfiguration;
import io.gatling.core.config.ConsoleDataWriterConfiguration;
import io.gatling.core.config.CoreConfiguration;
import io.gatling.core.config.CreateStatements;
import io.gatling.core.config.CssConfiguration;
import io.gatling.core.config.DBConfiguration;
import io.gatling.core.config.DataConfiguration;
import io.gatling.core.config.DirectoryConfiguration;
import io.gatling.core.config.ExtractConfiguration;
import io.gatling.core.config.FileDataWriterConfiguration;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GatlingConfiguration$ConfigStringSeq$;
import io.gatling.core.config.GraphiteDataWriterConfiguration;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.core.config.IndicatorsConfiguration;
import io.gatling.core.config.InsertStatements;
import io.gatling.core.config.JDBCDataWriterConfiguration;
import io.gatling.core.config.JacksonConfiguration;
import io.gatling.core.config.JsonPathConfiguration;
import io.gatling.core.config.RegexConfiguration;
import io.gatling.core.config.SslConfiguration;
import io.gatling.core.config.StoreConfiguration;
import io.gatling.core.config.TimeOutConfiguration;
import io.gatling.core.config.XPathConfiguration;
import io.gatling.core.config.ZincConfiguration;
import io.gatling.core.util.ConfigHelper$;
import io.gatling.core.util.StringHelper$;
import io.gatling.core.util.StringHelper$RichString$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map$;
import scala.package$;

public final class GatlingConfiguration$
implements StrictLogging,
Serializable {
    public static final GatlingConfiguration$ MODULE$;
    private GatlingConfiguration thisConfiguration;
    private final Logger logger;

    static {
        new GatlingConfiguration$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private GatlingConfiguration thisConfiguration() {
        return this.thisConfiguration;
    }

    private void thisConfiguration_$eq(GatlingConfiguration x$1) {
        this.thisConfiguration = x$1;
    }

    public GatlingConfiguration configuration() {
        return this.thisConfiguration();
    }

    public String ConfigStringSeq(String string) {
        return string;
    }

    public void set(GatlingConfiguration config) {
        this.thisConfiguration_$eq(config);
    }

    public GatlingConfiguration setUpForTest(scala.collection.mutable.Map<String, ?> props) {
        Config defaultsConfig = ConfigFactory.parseResources((ClassLoader)this.getClass().getClassLoader(), (String)"gatling-defaults.conf");
        Config propertiesConfig = ConfigFactory.parseMap((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)props.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ConfigKeys$data$.MODULE$.Writers()), (Object)""))));
        Config config = ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq<Config>)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, defaultsConfig}));
        this.thisConfiguration_$eq(this.mapToGatlingConfig(config));
        return this.thisConfiguration();
    }

    public void setUp(scala.collection.mutable.Map<String, ?> props) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Config defaultsConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)"gatling-defaults.conf");
        Config customConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)"gatling.conf");
        Config propertiesConfig = ConfigFactory.parseMap((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap(props));
        Config config = ConfigHelper$.MODULE$.configChain(ConfigFactory.systemProperties(), (Seq<Config>)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{propertiesConfig, customConfig, defaultsConfig}));
        this.warnAboutRemovedProperties$1(config);
        this.thisConfiguration_$eq(this.mapToGatlingConfig(config));
    }

    public scala.collection.mutable.Map<String, ?> setUpForTest$default$1() {
        return Map$.MODULE$.empty();
    }

    public scala.collection.mutable.Map<String, ?> setUp$default$1() {
        return Map$.MODULE$.empty();
    }

    private GatlingConfiguration mapToGatlingConfig(Config config) {
        String string;
        Option<String> x$3 = StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.OutputDirectoryBaseName())));
        Option<String> x$4 = StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.RunDescription())));
        String x$5 = config.getString(ConfigKeys$core$.MODULE$.Encoding());
        Option<String> x$6 = StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$.MODULE$.SimulationClass())));
        boolean x$7 = config.getBoolean(ConfigKeys$core$.MODULE$.DisableCompiler());
        boolean x$8 = config.getBoolean(ConfigKeys$core$.MODULE$.Mute());
        ExtractConfiguration x$9 = new ExtractConfiguration(new RegexConfiguration(config.getLong(ConfigKeys$core$extract$regex$.MODULE$.CacheMaxCapacity())), new XPathConfiguration(config.getLong(ConfigKeys$core$extract$xpath$.MODULE$.CacheMaxCapacity())), new JsonPathConfiguration(config.getLong(ConfigKeys$core$extract$jsonPath$.MODULE$.CacheMaxCapacity()), config.getBoolean(ConfigKeys$core$extract$jsonPath$.MODULE$.PreferJackson()), new JacksonConfiguration(config.getBoolean(ConfigKeys$core$extract$jsonPath$jackson$.MODULE$.AllowComments()), config.getBoolean(ConfigKeys$core$extract$jsonPath$jackson$.MODULE$.AllowUnquotedFieldNames()), config.getBoolean(ConfigKeys$core$extract$jsonPath$jackson$.MODULE$.AllowSingleQuotes()))), new CssConfiguration(config.getLong(ConfigKeys$core$extract$css$.MODULE$.CacheMaxCapacity())));
        TimeOutConfiguration x$10 = new TimeOutConfiguration(config.getInt(ConfigKeys$core$timeOut$.MODULE$.Simulation()));
        DirectoryConfiguration x$11 = new DirectoryConfiguration(config.getString(ConfigKeys$core$directory$.MODULE$.Data()), config.getString(ConfigKeys$core$directory$.MODULE$.RequestBodies()), config.getString(ConfigKeys$core$directory$.MODULE$.Simulations()), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$directory$.MODULE$.Binaries()))), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$core$directory$.MODULE$.ReportsOnly()))), config.getString(ConfigKeys$core$directory$.MODULE$.Results()));
        ZincConfiguration x$12 = new ZincConfiguration(config.getString(ConfigKeys$core$zinc$.MODULE$.JvmArgs()).split(" "));
        Option trustStore = this.storeConfig$1(ConfigKeys$http$ssl$trustStore$.MODULE$.Type(), ConfigKeys$http$ssl$trustStore$.MODULE$.File(), ConfigKeys$http$ssl$trustStore$.MODULE$.Password(), ConfigKeys$http$ssl$trustStore$.MODULE$.Algorithm(), config);
        Option keyStore = this.storeConfig$1(ConfigKeys$http$ssl$keyStore$.MODULE$.Type(), ConfigKeys$http$ssl$keyStore$.MODULE$.File(), ConfigKeys$http$ssl$keyStore$.MODULE$.Password(), ConfigKeys$http$ssl$keyStore$.MODULE$.Algorithm(), config);
        Seq x$13 = (Seq)GatlingConfiguration$ConfigStringSeq$.MODULE$.toStringList$extension(this.ConfigStringSeq(config.getString(ConfigKeys$data$.MODULE$.Writers()))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$1) {
                String string;
                String string2;
                String string3 = string2 = x0$1;
                if (!("console" != null ? !"console".equals(string3) : string3 != null)) {
                    string = "io.gatling.core.result.writer.ConsoleDataWriter";
                } else {
                    String string4 = string2;
                    if (!("file" != null ? !"file".equals(string4) : string4 != null)) {
                        string = "io.gatling.core.result.writer.FileDataWriter";
                    } else {
                        String string5 = string2;
                        if (!("graphite" != null ? !"graphite".equals(string5) : string5 != null)) {
                            string = "io.gatling.metrics.GraphiteDataWriter";
                        } else {
                            String string6 = string2;
                            if (!("jdbc" != null ? !"jdbc".equals(string6) : string6 != null)) {
                                string = "io.gatling.jdbc.result.writer.JdbcDataWriter";
                            } else {
                                String string7 = string2;
                                string = !("leak" != null ? !"leak".equals(string7) : string7 != null) ? "io.gatling.core.result.writer.LeakReporterDataWriter" : string2;
                            }
                        }
                    }
                }
                return string;
            }
        }, List$.MODULE$.canBuildFrom());
        String string2 = string = config.getString(ConfigKeys$data$.MODULE$.Reader()).trim();
        String string3 = !("file" != null ? !"file".equals(string2) : string2 != null) ? "io.gatling.charts.result.reader.FileDataReader" : string;
        String x$14 = string3;
        ConsoleDataWriterConfiguration x$15 = new ConsoleDataWriterConfiguration(config.getBoolean(ConfigKeys$data$console$.MODULE$.Light()));
        FileDataWriterConfiguration x$16 = new FileDataWriterConfiguration(config.getInt(ConfigKeys$data$file$.MODULE$.BufferSize()));
        GraphiteDataWriterConfiguration x$17 = new GraphiteDataWriterConfiguration(config.getBoolean(ConfigKeys$data$graphite$.MODULE$.Light()), config.getString(ConfigKeys$data$graphite$.MODULE$.Host()), config.getInt(ConfigKeys$data$graphite$.MODULE$.Port()), config.getString(ConfigKeys$data$graphite$.MODULE$.Protocol()), config.getString(ConfigKeys$data$graphite$.MODULE$.RootPathPrefix()), config.getInt(ConfigKeys$data$graphite$.MODULE$.BufferSize()));
        JDBCDataWriterConfiguration x$18 = new JDBCDataWriterConfiguration(new DBConfiguration(config.getString(ConfigKeys$data$jdbc$.MODULE$.Url()), config.getString(ConfigKeys$data$jdbc$.MODULE$.Username()), config.getString(ConfigKeys$data$jdbc$.MODULE$.Password())), config.getInt(ConfigKeys$data$jdbc$.MODULE$.BufferSize()), new CreateStatements(StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$create$.MODULE$.CreateRunRecordTable()))), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$create$.MODULE$.CreateRequestRecordTable()))), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$create$.MODULE$.CreateScenarioRecordTable()))), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$create$.MODULE$.CreateGroupRecordTable())))), new InsertStatements(StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$insert$.MODULE$.InsertRunRecord()))), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$insert$.MODULE$.InsertRequestRecord()))), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$insert$.MODULE$.InsertScenarioRecord()))), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$data$jdbc$insert$.MODULE$.InsertGroupRecord())))));
        return new GatlingConfiguration(new CoreConfiguration(x$3, x$4, x$5, x$6, x$7, x$9, x$10, x$11, x$8, x$12), new ChartingConfiguration(config.getBoolean(ConfigKeys$charting$.MODULE$.NoReports()), config.getInt(ConfigKeys$charting$.MODULE$.MaxPlotPerSeries()), config.getInt(ConfigKeys$charting$.MODULE$.Accuracy()), new IndicatorsConfiguration(config.getInt(ConfigKeys$charting$indicators$.MODULE$.LowerBound()), config.getInt(ConfigKeys$charting$indicators$.MODULE$.HigherBound()), config.getInt(ConfigKeys$charting$indicators$.MODULE$.Percentile1()), config.getInt(ConfigKeys$charting$indicators$.MODULE$.Percentile2()))), new HttpConfiguration(config.getLong(ConfigKeys$http$.MODULE$.ELFileBodiesCacheMaxCapacity()), config.getLong(ConfigKeys$http$.MODULE$.RawFileBodiesCacheMaxCapacity()), config.getLong(ConfigKeys$http$.MODULE$.FetchedCssCacheMaxCapacity()), config.getLong(ConfigKeys$http$.MODULE$.FetchedHtmlCacheMaxCapacity()), config.getLong(ConfigKeys$http$.MODULE$.RedirectPerUserCacheMaxCapacity()), config.getLong(ConfigKeys$http$.MODULE$.ExpirePerUserCacheMaxCapacity()), config.getLong(ConfigKeys$http$.MODULE$.LastModifiedPerUserCacheMaxCapacity()), config.getLong(ConfigKeys$http$.MODULE$.EtagPerUserCacheMaxCapacity()), StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config.getString(ConfigKeys$http$.MODULE$.WarmUpUrl()))), new SslConfiguration((Option<StoreConfiguration>)trustStore, (Option<StoreConfiguration>)keyStore), new AHCConfiguration(config.getBoolean(ConfigKeys$http$ahc$.MODULE$.AllowPoolingConnections()), config.getBoolean(ConfigKeys$http$ahc$.MODULE$.AllowPoolingSslConnections()), config.getBoolean(ConfigKeys$http$ahc$.MODULE$.CompressionEnabled()), config.getInt(ConfigKeys$http$ahc$.MODULE$.ConnectionTimeout()), config.getInt(ConfigKeys$http$ahc$.MODULE$.PooledConnectionIdleTimeout()), config.getInt(ConfigKeys$http$ahc$.MODULE$.ReadTimeout()), config.getInt(ConfigKeys$http$ahc$.MODULE$.ConnectionTTL()), config.getInt(ConfigKeys$http$ahc$.MODULE$.IoThreadMultiplier()), config.getInt(ConfigKeys$http$ahc$.MODULE$.MaxConnectionsPerHost()), config.getInt(ConfigKeys$http$ahc$.MODULE$.MaxConnections()), config.getInt(ConfigKeys$http$ahc$.MODULE$.MaxRetry()), config.getInt(ConfigKeys$http$ahc$.MODULE$.RequestTimeout()), config.getBoolean(ConfigKeys$http$ahc$.MODULE$.UseProxyProperties()), config.getInt(ConfigKeys$http$ahc$.MODULE$.WebSocketTimeout()), config.getBoolean(ConfigKeys$http$ahc$.MODULE$.UseRelativeURIsWithConnectProxies()), config.getBoolean(ConfigKeys$http$ahc$.MODULE$.AcceptAnyCertificate()), config.getInt(ConfigKeys$http$ahc$.MODULE$.HttpClientCodecMaxInitialLineLength()), config.getInt(ConfigKeys$http$ahc$.MODULE$.HttpClientCodecMaxHeaderSize()), config.getInt(ConfigKeys$http$ahc$.MODULE$.HttpClientCodecMaxChunkSize()))), new DataConfiguration((Seq<String>)x$13, x$14, x$16, x$18, x$15, x$17), config);
    }

    public GatlingConfiguration apply(CoreConfiguration core, ChartingConfiguration charting, HttpConfiguration http, DataConfiguration data, Config config) {
        return new GatlingConfiguration(core, charting, http, data, config);
    }

    public Option<Tuple5<CoreConfiguration, ChartingConfiguration, HttpConfiguration, DataConfiguration, Config>> unapply(GatlingConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.core(), (Object)x$0.charting(), (Object)x$0.http(), (Object)x$0.data(), (Object)x$0.config()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final void io$gatling$core$config$GatlingConfiguration$$warnAboutRemovedProperty$1(String path, Config config$2) {
        if (config$2.hasPath(path) && this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beware, property ", " is still defined but it was removed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
    }

    private final void warnAboutRemovedProperties$1(Config config) {
        ((IterableLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gatling.core.extract.xpath.saxParserFactory", "gatling.core.extract.xpath.domParserFactory", "gatling.core.extract.xpath.expandEntityReferences", "gatling.core.extract.xpath.namespaceAware", "gatling.core.extract.css.engine", "gatling.core.timeOut.actor", "gatling.charting.statsTsvSeparator", "gatling.http.baseUrls", "gatling.http.proxy.host", "gatling.http.proxy.port", "gatling.http.proxy.securedPort", "gatling.http.proxy.username", "gatling.http.proxy.password", "gatling.http.followRedirect", "gatling.http.autoReferer", "gatling.http.cache", "gatling.http.discardResponseChunks", "gatling.http.shareConnections", "gatling.http.basicAuth.username", "gatling.http.basicAuth.password", "gatling.http.ahc.provider", "gatling.http.ahc.requestCompressionLevel", "gatling.http.ahc.userAgent", "gatling.http.ahc.rfc6265CookieEncoding", "gatling.http.ahc.useRawUrl", "gatling.http.ahc.allowPoolingConnection", "gatling.http.ahc.allowSslConnectionPool", "gatling.http.ahc.idleConnectionInPoolTimeoutInMs", "gatling.http.ahc.maximumConnectionsPerHost", "gatling.http.ahc.maximumConnectionsTotal", "gatling.http.ahc.requestTimeoutInMs", "gatling.http.ahc.maxConnectionLifeTimeInMs"}))).foreach((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$2;

            public final void apply(String path) {
                GatlingConfiguration$.MODULE$.io$gatling$core$config$GatlingConfiguration$$warnAboutRemovedProperty$1(path, this.config$2);
            }
            {
                this.config$2 = config$2;
            }
        });
    }

    private final Option storeConfig$1(String typeKey, String fileKey, String passwordKey, String algorithmKey, Config config$1) {
        Option<String> storeType = StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config$1.getString(typeKey)));
        Option<String> storeFile = StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config$1.getString(fileKey)));
        String storePassword = config$1.getString(passwordKey);
        Option<String> storeAlgorithm = StringHelper$RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(config$1.getString(algorithmKey)));
        return storeFile.map((Function1)new Serializable(storeType, storePassword, storeAlgorithm){
            public static final long serialVersionUID = 0L;
            private final Option storeType$1;
            private final String storePassword$1;
            private final Option storeAlgorithm$1;

            public final StoreConfiguration apply(String x$2) {
                return new StoreConfiguration((Option<String>)this.storeType$1, x$2, this.storePassword$1, (Option<String>)this.storeAlgorithm$1);
            }
            {
                this.storeType$1 = storeType$1;
                this.storePassword$1 = storePassword$1;
                this.storeAlgorithm$1 = storeAlgorithm$1;
            }
        });
    }

    private GatlingConfiguration$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

