/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.config;

import io.gatling.core.config.GatlingConfiguration$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.io.Directory;
import scala.reflect.io.Path;
import scala.tools.nsc.io.package$;
import scala.util.Properties$;

public final class GatlingFiles$ {
    public static final GatlingFiles$ MODULE$;
    private final String GatlingHome;
    private final String GatlingAssetsPackage;
    private final String GatlingJsFolder;
    private final String GatlingStyleFolder;
    private final Path GatlingAssetsJsPackage;
    private final Path GatlingAssetsStylePackage;

    static {
        new GatlingFiles$();
    }

    public String GatlingHome() {
        return this.GatlingHome;
    }

    public String GatlingAssetsPackage() {
        return this.GatlingAssetsPackage;
    }

    public String GatlingJsFolder() {
        return this.GatlingJsFolder;
    }

    public String GatlingStyleFolder() {
        return this.GatlingStyleFolder;
    }

    public Path GatlingAssetsJsPackage() {
        return this.GatlingAssetsJsPackage;
    }

    public Path GatlingAssetsStylePackage() {
        return this.GatlingAssetsStylePackage;
    }

    private Path resolvePath(String path) {
        Path rawPath = package$.MODULE$.Path().apply(path);
        return rawPath.isAbsolute() || rawPath.exists() ? package$.MODULE$.Path().string2path(path) : package$.MODULE$.Path().string2path(this.GatlingHome()).$div(package$.MODULE$.Path().string2path(path));
    }

    public Path dataDirectory() {
        return this.resolvePath(GatlingConfiguration$.MODULE$.configuration().core().directory().data());
    }

    public Path requestBodiesDirectory() {
        return this.resolvePath(GatlingConfiguration$.MODULE$.configuration().core().directory().requestBodies());
    }

    public Directory sourcesDirectory() {
        return this.resolvePath(GatlingConfiguration$.MODULE$.configuration().core().directory().sources()).toDirectory();
    }

    public Option<String> reportsOnlyDirectory() {
        return GatlingConfiguration$.MODULE$.configuration().core().directory().reportsOnly();
    }

    public Option<Directory> binariesDirectory() {
        return GatlingConfiguration$.MODULE$.configuration().core().directory().binaries().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Directory apply(String x$1) {
                return package$.MODULE$.Path().string2path(x$1).toDirectory();
            }
        });
    }

    public Path resultDirectory(String runUuid) {
        return this.resolvePath(GatlingConfiguration$.MODULE$.configuration().core().directory().results()).$div(package$.MODULE$.Path().string2path(runUuid));
    }

    public Path jsDirectory(String runUuid) {
        return this.resultDirectory(runUuid).$div(package$.MODULE$.Path().string2path(this.GatlingJsFolder()));
    }

    public Path styleDirectory(String runUuid) {
        return this.resultDirectory(runUuid).$div(package$.MODULE$.Path().string2path(this.GatlingStyleFolder()));
    }

    public Directory simulationLogDirectory(String runUuid, boolean create) {
        Directory directory;
        Path dir = this.resultDirectory(runUuid);
        if (create) {
            directory = dir.createDirectory(dir.createDirectory$default$1(), dir.createDirectory$default$2());
        } else {
            Predef$.MODULE$.require(dir.exists(), (Function0)new Serializable(dir){
                public static final long serialVersionUID = 0L;
                private final Path dir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"simulation directory '", "' doesn't exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1.toAbsolute()}));
                }
                {
                    this.dir$1 = dir$1;
                }
            });
            Predef$.MODULE$.require(dir.isDirectory(), (Function0)new Serializable(dir){
                public static final long serialVersionUID = 0L;
                private final Path dir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"simulation directory '", "' is not a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1.toAbsolute()}));
                }
                {
                    this.dir$1 = dir$1;
                }
            });
            directory = dir.toDirectory();
        }
        return directory;
    }

    public boolean simulationLogDirectory$default$2() {
        return true;
    }

    private GatlingFiles$() {
        MODULE$ = this;
        this.GatlingHome = Properties$.MODULE$.envOrElse("GATLING_HOME", Properties$.MODULE$.propOrElse("GATLING_HOME", "."));
        this.GatlingAssetsPackage = "assets";
        this.GatlingJsFolder = "js";
        this.GatlingStyleFolder = "style";
        this.GatlingAssetsJsPackage = package$.MODULE$.Path().string2path(this.GatlingAssetsPackage()).$div(package$.MODULE$.Path().string2path(this.GatlingJsFolder()));
        this.GatlingAssetsStylePackage = package$.MODULE$.Path().string2path(this.GatlingAssetsPackage()).$div(package$.MODULE$.Path().string2path(this.GatlingStyleFolder()));
    }
}

