/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.random;

import java.util.Random;
import org.uncommons.maths.binary.BinaryUtils;
import org.uncommons.maths.random.DefaultSeedGenerator;
import org.uncommons.maths.random.RepeatableRNG;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public class UnsafeMersenneTwisterRNG
extends Random
implements RepeatableRNG {
    private static final int SEED_SIZE_BYTES = 16;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAG01 = new int[]{0, -1727483681};
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int BOOTSTRAP_SEED = 19650218;
    private static final int BOOTSTRAP_FACTOR = 1812433253;
    private static final int SEED_FACTOR1 = 1664525;
    private static final int SEED_FACTOR2 = 1566083941;
    private static final int GENERATE_MASK1 = -1658038656;
    private static final int GENERATE_MASK2 = -272236544;
    private final byte[] seed;
    private final int[] mt = new int[624];
    private int mtIndex = 0;

    public UnsafeMersenneTwisterRNG() {
        this(DefaultSeedGenerator.getInstance().generateSeed(16));
    }

    public UnsafeMersenneTwisterRNG(SeedGenerator seedGenerator) throws SeedException {
        this(seedGenerator.generateSeed(16));
    }

    public UnsafeMersenneTwisterRNG(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException("Mersenne Twister RNG requires a 128-bit (16-byte) seed.");
        }
        this.seed = (byte[])byArray.clone();
        int[] nArray = BinaryUtils.convertBytesToInts((byte[])this.seed);
        this.mt[0] = 19650218;
        this.mtIndex = 1;
        while (this.mtIndex < 624) {
            this.mt[this.mtIndex] = 1812433253 * (this.mt[this.mtIndex - 1] ^ this.mt[this.mtIndex - 1] >>> 30) + this.mtIndex;
            ++this.mtIndex;
        }
        int n2 = 1;
        int n3 = 0;
        for (n = Math.max(624, nArray.length); n > 0; --n) {
            this.mt[n2] = (this.mt[n2] ^ (this.mt[n2 - 1] ^ this.mt[n2 - 1] >>> 30) * 1664525) + nArray[n3] + n3;
            ++n3;
            if (++n2 >= 624) {
                this.mt[0] = this.mt[623];
                n2 = 1;
            }
            if (n3 < nArray.length) continue;
            n3 = 0;
        }
        for (n = 623; n > 0; --n) {
            this.mt[n2] = (this.mt[n2] ^ (this.mt[n2 - 1] ^ this.mt[n2 - 1] >>> 30) * 1566083941) - n2;
            if (++n2 < 624) continue;
            this.mt[0] = this.mt[623];
            n2 = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    @Override
    protected final int next(int n) {
        int n2;
        if (this.mtIndex >= 624) {
            int n3;
            for (n3 = 0; n3 < 227; ++n3) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n2 >>> 1 ^ MAG01[n2 & 1];
            }
            while (n3 < 623) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + -227] ^ n2 >>> 1 ^ MAG01[n2 & 1];
                ++n3;
            }
            n2 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n2 >>> 1 ^ MAG01[n2 & 1];
            this.mtIndex = 0;
        }
        n2 = this.mt[this.mtIndex++];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        return n2 >>> 32 - n;
    }
}

