/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.DataWriterMessage$Flush$;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.UserCounters;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mb!B\b\u0011\u0005YQ\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u00111\u0002!\u0011!Q\u0001\n5BQa\r\u0001\u0005\u0002QBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006\u001d\u0002!\te\u0014\u0005\u00061\u0002!\t%\u0017\u0005\u0006A\u0002!I!\u0019\u0005\u0006Y\u0002!I!\u001c\u0005\u0006g\u0002!I\u0001\u001e\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\t9\u0002\u0001C!\u00033Aq!!\u000e\u0001\t\u0003\n9DA\tD_:\u001cx\u000e\\3ECR\fwK]5uKJT!!\u0005\n\u0002\r]\u0014\u0018\u000e^3s\u0015\t\u0019B#A\u0003ti\u0006$8O\u0003\u0002\u0016-\u0005!1m\u001c:f\u0015\t9\u0002$A\u0004hCRd\u0017N\\4\u000b\u0003e\t!![8\u0014\u0005\u0001Y\u0002c\u0001\u000f\u001e?5\t\u0001#\u0003\u0002\u001f!\tQA)\u0019;b/JLG/\u001a:\u0011\u0005q\u0001\u0013BA\u0011\u0011\u0005-\u0019uN\\:pY\u0016$\u0015\r^1\u0002\u000b\rdwnY6\u0004\u0001A\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005kRLGN\u0003\u0002*-\u000591m\\7n_:\u001c\u0018BA\u0016'\u0005\u0015\u0019En\\2l\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011a&M\u0007\u0002_)\u0011\u0001\u0007F\u0001\u0007G>tg-[4\n\u0005Iz#\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004kY:\u0004C\u0001\u000f\u0001\u0011\u0015\u00113\u00011\u0001%\u0011\u0015a3\u00011\u0001.\u000391G.^:i)&lWM\u001d(b[\u0016,\u0012A\u000f\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019\u0019FO]5oO\u0006ya\r\\;tQRKW.\u001a:OC6,\u0007%\u0001\u0004p]&s\u0017\u000e\u001e\u000b\u0003?\u0015CQA\u0012\u0004A\u0002\u001d\u000bA!\u001b8jiB\u0011\u0001j\u0013\b\u00039%K!A\u0013\t\u0002#\u0011\u000bG/Y,sSR,'/T3tg\u0006<W-\u0003\u0002M\u001b\n!\u0011J\\5u\u0015\tQ\u0005#A\u0004p]\u001acWo\u001d5\u0015\u0005A3\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&\u0001B+oSRDQaV\u0004A\u0002}\tA\u0001Z1uC\u0006IqN\\'fgN\fw-\u001a\u000b\u0004!j{\u0006\"B.\t\u0001\u0004a\u0016aB7fgN\fw-\u001a\t\u0003\u0011vK!AX'\u0003\u00131{\u0017\rZ#wK:$\b\"B,\t\u0001\u0004y\u0012AE8o+N,'o\u0015;beRlUm]:bO\u0016$2\u0001\u00152l\u0011\u0015\u0019\u0017\u00021\u0001e\u0003\u0011)8/\u001a:\u0011\u0005\u0015DgB\u0001%g\u0013\t9W*A\u0005M_\u0006$WI^3oi&\u0011\u0011N\u001b\u0002\n+N,'o\u0015;beRT!aZ'\t\u000b]K\u0001\u0019A\u0010\u0002!=tWk]3s\u000b:$W*Z:tC\u001e,Gc\u0001)oe\")1M\u0003a\u0001_B\u0011Q\r]\u0005\u0003c*\u0014q!V:fe\u0016sG\rC\u0003X\u0015\u0001\u0007q$A\tp]J+7\u000f]8og\u0016lUm]:bO\u0016$2\u0001U;{\u0011\u001518\u00021\u0001x\u0003!\u0011Xm\u001d9p]N,\u0007CA3y\u0013\tI(N\u0001\u0005SKN\u0004xN\\:f\u0011\u001596\u00021\u0001 Q\u0015YAp`A\u0001!\tYT0\u0003\u0002\u007fy\t\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u0007\t#!!\u0002\u0002A=\u0014xML<beR\u0014X-\\8wKJts/\u0019:ug:b\u0015n\u001d;BaB,g\u000eZ\u0001\u000f_:,%O]8s\u001b\u0016\u001c8/Y4f)\u0015\u0001\u00161BA\u000b\u0011\u001d\ti\u0001\u0004a\u0001\u0003\u001f\tQ!\u001a:s_J\u00042!ZA\t\u0013\r\t\u0019B\u001b\u0002\u0006\u000bJ\u0014xN\u001d\u0005\u0006/2\u0001\raH\u0001\b_:\u001c%/Y:i)\u0015\u0001\u00161DA\u001a\u0011\u001d\ti\"\u0004a\u0001\u0003?\tQaY1vg\u0016\u0004B!!\t\u000209!\u00111EA\u0016!\r\t)CU\u0007\u0003\u0003OQ1!!\u000b$\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0006*\u0002\rA\u0013X\rZ3g\u0013\r\t\u0015\u0011\u0007\u0006\u0004\u0003[\u0011\u0006\"B,\u000e\u0001\u0004y\u0012AB8o'R|\u0007\u000fF\u0002Q\u0003sAQa\u0016\bA\u0002}\u0001")
public final class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    @Override
    public ConsoleData onInit(DataWriterMessage.Init init) {
        ConsoleData data = new ConsoleData(this.clock.nowMillis(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss O").withZone(init.runMessage().zoneId()));
        init.scenarios().foreach((Function1 & Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        this.startTimerAtFixedRate(this.flushTimerName(), DataWriterMessage$Flush$.MODULE$, this.configuration.data().console().writePeriod());
        return data;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, ZonedDateTime.now(), data.dateTimeFormatter());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(DataWriterMessage.LoadEvent message, ConsoleData data) {
        DataWriterMessage.LoadEvent loadEvent = message;
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserStart) {
            DataWriterMessage.LoadEvent.UserStart userStart = (DataWriterMessage.LoadEvent.UserStart)loadEvent;
            this.onUserStartMessage(userStart, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.UserEnd) {
            DataWriterMessage.LoadEvent.UserEnd userEnd = (DataWriterMessage.LoadEvent.UserEnd)loadEvent;
            this.onUserEndMessage(userEnd, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Response) {
            DataWriterMessage.LoadEvent.Response response = (DataWriterMessage.LoadEvent.Response)loadEvent;
            this.onResponseMessage(response, data);
            return;
        }
        if (loadEvent instanceof DataWriterMessage.LoadEvent.Error) {
            DataWriterMessage.LoadEvent.Error error = (DataWriterMessage.LoadEvent.Error)loadEvent;
            this.onErrorMessage(error, data);
            return;
        }
    }

    private void onUserStartMessage(DataWriterMessage.LoadEvent.UserStart user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userStart();
            return;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
            return;
        }
    }

    private void onUserEndMessage(DataWriterMessage.LoadEvent.UserEnd user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userDone();
            return;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", (Object)user.scenario());
            return;
        }
    }

    private void onResponseMessage(DataWriterMessage.LoadEvent.Response response, ConsoleData data) {
        String requestPath = ((IterableOnceOps)response.groupHierarchy().$colon$plus((Object)response.name())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable)() -> RequestCounters$.MODULE$.empty());
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            return;
        }
        if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
            return;
        }
        throw new MatchError((Object)status);
    }

    private void onErrorMessage(DataWriterMessage.LoadEvent.Error error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        this.cancelTimer(this.flushTimerName());
        if (!data.complete()) {
            this.onFlush(data);
            return;
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

