/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.commons.util.CircularIterator$;
import io.gatling.core.feeder.FeederStrategy;
import io.gatling.core.feeder.FeederStrategy$Circular$;
import io.gatling.core.feeder.FeederStrategy$Queue$;
import io.gatling.core.feeder.FeederStrategy$Random$;
import io.gatling.core.feeder.FeederStrategy$Shuffle$;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.util.Random$;

public final class InMemoryFeeder$ {
    public static final InMemoryFeeder$ MODULE$ = new InMemoryFeeder$();

    public <T> Iterator<Map<String, Object>> apply(IndexedSeq<Map<String, T>> records, Option<Function1<Map<String, T>, Map<String, Object>>> conversion, FeederStrategy strategy) {
        Iterator iterator;
        IndexedSeq indexedSeq;
        Option<Function1<Map<String, T>, Map<String, Object>>> option = conversion;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 f = (Function1)some.value();
            indexedSeq = (IndexedSeq)records.map(f);
        } else {
            indexedSeq = records;
        }
        IndexedSeq convertedRecords = indexedSeq;
        FeederStrategy feederStrategy = strategy;
        if (FeederStrategy$Queue$.MODULE$.equals(feederStrategy)) {
            iterator = convertedRecords.iterator();
        } else if (FeederStrategy$Random$.MODULE$.equals(feederStrategy)) {
            iterator = package$.MODULE$.Iterator().continually((Function0 & Serializable)() -> (Map)convertedRecords.apply(ThreadLocalRandom.current().nextInt(records.length())));
        } else if (FeederStrategy$Shuffle$.MODULE$.equals(feederStrategy)) {
            iterator = ((IndexedSeqOps)Random$.MODULE$.shuffle((IterableOnce)convertedRecords, BuildFrom$.MODULE$.buildFromIterableOps())).iterator();
        } else if (FeederStrategy$Circular$.MODULE$.equals(feederStrategy)) {
            iterator = CircularIterator$.MODULE$.apply(convertedRecords, false);
        } else {
            throw new MatchError((Object)feederStrategy);
        }
        return iterator;
    }

    private InMemoryFeeder$() {
    }
}

