/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.shared.util.StringBuilderPool;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;

public final class RequestTimeoutException
extends TimeoutException {
    private static String message(long l, InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get().append("Request timeout");
        if (inetSocketAddress != null) {
            stringBuilder.append(" to ").append(inetSocketAddress.getHostString());
            if (!inetSocketAddress.isUnresolved()) {
                stringBuilder.append('/').append(inetSocketAddress.getAddress().getHostAddress());
            }
            stringBuilder.append(':').append(inetSocketAddress.getPort());
        }
        return stringBuilder.append(" after ").append(l).append(" ms").toString();
    }

    RequestTimeoutException(long l, InetSocketAddress inetSocketAddress) {
        super(RequestTimeoutException.message(l, inetSocketAddress));
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }
}

