/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http;

import akka.actor.ActorRef;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.recorder.http.TrafficLogger;
import io.gatling.recorder.http.flows.MitmMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u000594A!\u0003\u0006\u0001'!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000b!\u0003A\u0011I%\t\u000bi\u0003A\u0011I.\t\u000bu\u0003A\u0011\t0\u0003\u001b\rc\u0017.\u001a8u\u0011\u0006tG\r\\3s\u0015\tYA\"\u0001\u0003iiR\u0004(BA\u0007\u000f\u0003!\u0011XmY8sI\u0016\u0014(BA\b\u0011\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!E\u0001\u0003S>\u001c\u0001aE\u0002\u0001)q\u0001\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\u000f\rD\u0017M\u001c8fY*\u0011\u0011\u0004E\u0001\u0006]\u0016$H/_\u0005\u00037Y\u0011Ad\u00115b]:,G.\u00138c_VtG\rS1oI2,'/\u00113baR,'\u000f\u0005\u0002\u001eI5\taD\u0003\u0002 A\u0005a1oY1mC2|wmZ5oO*\u0011\u0011EI\u0001\tif\u0004Xm]1gK*\t1%A\u0002d_6L!!\n\u0010\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003%i\u0017\u000e^7BGR|'\u000f\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005)\u0011m\u0019;pe*\tA&\u0001\u0003bW.\f\u0017B\u0001\u0018*\u0005!\t5\r^8s%\u00164\u0017aD:feZ,'o\u00115b]:,G.\u00133\u0011\u0005U\t\u0014B\u0001\u001a\u0017\u0005%\u0019\u0005.\u00198oK2LE-A\u0007ue\u00064g-[2M_\u001e<WM\u001d\t\u0003kYj\u0011AC\u0005\u0003o)\u0011Q\u0002\u0016:bM\u001aL7\rT8hO\u0016\u0014\u0018!B2m_\u000e\\\u0007C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0011)H/\u001b7\u000b\u0005yr\u0011aB2p[6|gn]\u0005\u0003\u0001n\u0012Qa\u00117pG.\fa\u0001P5oSRtD#B\"E\u000b\u001a;\u0005CA\u001b\u0001\u0011\u00151S\u00011\u0001(\u0011\u0015yS\u00011\u00011\u0011\u0015\u0019T\u00011\u00015\u0011\u0015AT\u00011\u0001:\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\u0007)\u0003V\u000b\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJ\u0001\u0003V]&$\b\"B)\u0007\u0001\u0004\u0011\u0016aA2uqB\u0011QcU\u0005\u0003)Z\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003W\r\u0001\u0007q+A\u0002ng\u001e\u0004\"a\u0013-\n\u0005ec%AB!osJ+g-A\bdQ\u0006tg.\u001a7J]\u0006\u001cG/\u001b<f)\tQE\fC\u0003R\u000f\u0001\u0007!+A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\rQu\f\u0019\u0005\u0006#\"\u0001\rA\u0015\u0005\u0006C\"\u0001\rAY\u0001\u0006G\u0006,8/\u001a\t\u0003G.t!\u0001Z5\u000f\u0005\u0015DW\"\u00014\u000b\u0005\u001d\u0014\u0012A\u0002\u001fs_>$h(C\u0001N\u0013\tQG*A\u0004qC\u000e\\\u0017mZ3\n\u00051l'!\u0003+ie><\u0018M\u00197f\u0015\tQG\n")
public class ClientHandler
extends ChannelInboundHandlerAdapter
implements StrictLogging {
    private final ActorRef mitmActor;
    private final ChannelId serverChannelId;
    private final TrafficLogger trafficLogger;
    private final Clock clock;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        long receiveTimestamp = this.clock.nowMillis();
        Object object = msg;
        if (object instanceof FullHttpResponse) {
            FullHttpResponse fullHttpResponse = (FullHttpResponse)object;
            this.trafficLogger.logResponse(this.serverChannelId, fullHttpResponse, receiveTimestamp);
            MitmMessage.ResponseReceived x$1 = new MitmMessage.ResponseReceived(fullHttpResponse);
            ActorRef x$2 = this.mitmActor.$bang$default$2((Object)x$1);
            this.mitmActor.$bang((Object)x$1, x$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Received unknown message: {}", object);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        MitmMessage.ClientChannelInactive x$1 = new MitmMessage.ClientChannelInactive(ctx.channel().id());
        ActorRef x$2 = this.mitmActor.$bang$default$2((Object)x$1);
        this.mitmActor.$bang((Object)x$1, x$2);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        MitmMessage.ClientChannelException x$1 = new MitmMessage.ClientChannelException(cause);
        ActorRef x$2 = this.mitmActor.$bang$default$2((Object)x$1);
        this.mitmActor.$bang((Object)x$1, x$2);
    }

    public ClientHandler(ActorRef mitmActor, ChannelId serverChannelId, TrafficLogger trafficLogger, Clock clock) {
        this.mitmActor = mitmActor;
        this.serverChannelId = serverChannelId;
        this.trafficLogger = trafficLogger;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

