/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.metric;

import io.getunleash.lang.Nullable;
import io.getunleash.metric.ToggleCount;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class MetricsBucket {
    private final ConcurrentMap<String, ToggleCount> toggles;
    private final LocalDateTime start = LocalDateTime.now(ZoneId.of("UTC"));
    @Nullable
    private volatile LocalDateTime stop;

    MetricsBucket() {
        this.toggles = new ConcurrentHashMap<String, ToggleCount>();
    }

    void registerCount(String toggleName, boolean active) {
        this.getOrCreate(toggleName).register(active);
    }

    void registerCount(String toggleName, String variantName) {
        this.getOrCreate(toggleName).register(variantName);
    }

    private ToggleCount getOrCreate(String toggleName) {
        return this.toggles.computeIfAbsent(toggleName, s -> new ToggleCount());
    }

    void end() {
        this.stop = LocalDateTime.now(ZoneId.of("UTC"));
    }

    public Map<String, ToggleCount> getToggles() {
        return this.toggles;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    @Nullable
    public LocalDateTime getStop() {
        return this.stop;
    }
}

