/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.PopulatorContextStackItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.RandomUtils;

class PopulatorContext {
    static final byte OBJECT_POOL_SIZE = 10;
    private String[] excludedFields;
    private Map<Class<?>, List<Object>> populatedBeans = new IdentityHashMap();
    private Stack<PopulatorContextStackItem> stack = new Stack();

    PopulatorContext(String ... excludedFields) {
        this.excludedFields = excludedFields;
    }

    void addPopulatedBean(Class<?> type, Object object) {
        List<Object> objects = this.populatedBeans.get(type);
        if (objects == null) {
            objects = new ArrayList<Object>(10);
        }
        if (objects.size() < 10) {
            objects.add(object);
        }
        this.populatedBeans.put(type, objects);
    }

    Object getPopulatedBean(Class<?> type) {
        int actualPoolSize = this.populatedBeans.get(type).size();
        int randomIndex = actualPoolSize > 1 ? RandomUtils.nextInt((int)0, (int)actualPoolSize) : 0;
        return this.populatedBeans.get(type).get(randomIndex);
    }

    boolean hasRandomizedType(Class<?> type) {
        return this.populatedBeans.containsKey(type) && this.populatedBeans.get(type).size() == 10;
    }

    String[] getExcludedFields() {
        return this.excludedFields;
    }

    void pushStackItem(PopulatorContextStackItem field) {
        this.stack.push(field);
    }

    PopulatorContextStackItem popStackItem() {
        return this.stack.pop();
    }

    String getFieldFullName(Field field) {
        StringBuilder builder = new StringBuilder();
        List<Field> stackedFields = this.getStackedFields();
        this.appendDottedName(builder, stackedFields);
        this.appendDottedName(builder, Collections.singletonList(field));
        return builder.toString();
    }

    List<Field> getStackedFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (PopulatorContextStackItem stackItem : this.stack) {
            fields.add(stackItem.getField());
        }
        return fields;
    }

    void appendDottedName(StringBuilder builder, List<Field> fields) {
        for (Field field : fields) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(field.getName());
        }
    }
}

