/*
 * Decompiled with CFR 0.152.
 */
package io.github.glytching.junit.extension.benchmark;

import io.github.glytching.junit.extension.benchmark.StopWatch;
import io.github.glytching.junit.extension.util.ExtensionUtil;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class BenchmarkExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public static final String REPORT_EVENT_FORMAT = "Elapsed time in %s for %s";
    private final TimeUnit timeUnit;

    public BenchmarkExtension() {
        this(TimeUnit.MILLISECONDS);
    }

    public BenchmarkExtension(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        ExtensionUtil.getStore(extensionContext, this.getClass()).put((Object)extensionContext.getRequiredTestMethod(), (Object)new StopWatch());
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        Method testMethod = extensionContext.getRequiredTestMethod();
        long duration = ((StopWatch)ExtensionUtil.getStore(extensionContext, this.getClass()).get((Object)testMethod, StopWatch.class)).duration(this.timeUnit);
        extensionContext.publishReportEntry(String.format(REPORT_EVENT_FORMAT, this.timeUnit.name(), testMethod.getName()), Long.toString(duration));
    }
}

