/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.limiter;

import io.github.icodegarden.commons.lang.limiter.CounterRateLimiterSupport;
import java.util.concurrent.atomic.AtomicInteger;

public class CounterRateLimiter
extends CounterRateLimiterSupport {
    private int count;
    private AtomicInteger token;

    public CounterRateLimiter(int count, long interval) {
        super(interval);
        if (count <= 0) {
            throw new IllegalArgumentException("count must gt 0");
        }
        this.count = count;
    }

    @Override
    protected void resetToken() {
        this.token = new AtomicInteger(this.count);
    }

    @Override
    protected int getAndDecrement(int value) {
        return this.token.getAndAdd(-value);
    }
}

