/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.limiter;

import io.github.icodegarden.commons.lang.limiter.RateLimiter;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBucketRateLimiter
implements RateLimiter {
    private static final Logger log = LoggerFactory.getLogger(TokenBucketRateLimiter.class);
    private int tokenSize;
    private int inputSize;
    private Duration inputDuration;
    private long lastResetTime = System.currentTimeMillis();
    private AtomicInteger token;

    public TokenBucketRateLimiter(int tokenSize, int inputSize, Duration inputDuration) {
        this.token = new AtomicInteger(tokenSize);
        this.tokenSize = tokenSize;
        this.inputSize = inputSize;
        this.inputDuration = inputDuration;
    }

    private void reset() {
        long now = System.currentTimeMillis();
        long cost = now - this.lastResetTime;
        double rate = (double)cost * 1.0 / (double)this.inputDuration.toMillis();
        int shouldInput = (int)((double)this.inputSize * rate);
        if (shouldInput == 0) {
            return;
        }
        this.token.updateAndGet(pre -> {
            int v = pre + shouldInput;
            return v <= this.tokenSize ? v : this.tokenSize;
        });
        this.lastResetTime = System.currentTimeMillis();
    }

    @Override
    public boolean isAllowable(int weight) {
        if (this.token.intValue() < weight) {
            this.reset();
        }
        if (this.token.intValue() < weight) {
            if (log.isInfoEnabled()) {
                log.info("{}:{} not allowed", (Object)TokenBucketRateLimiter.class.getSimpleName(), (Object)this.getName());
            }
            return false;
        }
        this.token.addAndGet(-weight);
        return true;
    }
}

