/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.metrics;

import io.github.icodegarden.commons.lang.NamesCachedObjectReader;
import io.github.icodegarden.commons.lang.metrics.InstanceMetrics;
import io.github.icodegarden.commons.lang.metrics.Metrics;
import io.github.icodegarden.commons.lang.registry.RegisteredInstance;
import java.io.IOException;
import java.util.List;

public class NamesCachedInstanceMetrics
implements InstanceMetrics<Metrics> {
    private final InstanceMetrics<? extends Metrics> delegator;
    private final NamesCachedObjectReader namesCachedObjectReader;

    public NamesCachedInstanceMetrics(List<String> serviceNames, InstanceMetrics<? extends Metrics> delegator, long cacheRefreshIntervalMillis) throws IllegalArgumentException {
        if (serviceNames == null || serviceNames.isEmpty()) {
            throw new IllegalArgumentException("serviceNames must not empty");
        }
        if (delegator == null) {
            throw new IllegalArgumentException("param delegator must not null");
        }
        this.delegator = delegator;
        this.namesCachedObjectReader = new NamesCachedObjectReader(serviceNames, delegator, cacheRefreshIntervalMillis);
    }

    @Override
    public List<Metrics> listNamedObjects(String serviceName) {
        return this.namesCachedObjectReader.listNamedObjects(serviceName);
    }

    @Override
    public <T extends RegisteredInstance> void setMetrics(T instance, Metrics metrics) {
        this.delegator.setMetrics(instance, metrics);
    }

    @Override
    public <T extends RegisteredInstance> Metrics getMetrics(T instance) {
        return this.delegator.getMetrics(instance);
    }

    @Override
    public <T extends RegisteredInstance> void removeMetrics(T instance) {
        this.delegator.removeMetrics(instance);
    }

    @Override
    public void close() throws IOException {
        this.namesCachedObjectReader.close();
    }
}

