/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.query;

import io.github.icodegarden.commons.lang.query.NextQuerySupportList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NextQuerySupportArrayList<E>
extends ArrayList<E>
implements NextQuerySupportList<E> {
    private static final long serialVersionUID = 1L;
    private static final NextQuerySupportArrayList EMPTY = new NextQuerySupportArrayList();
    private boolean hasNextPage;
    private String searchAfter;

    public static <E> NextQuerySupportArrayList<E> newSupportSearchAfter(List<E> source, Function<? super E, String> searchAfterSupplier) {
        return NextQuerySupportArrayList.newSupportSearchAfter(source, e -> e, searchAfterSupplier);
    }

    public static <E, R> NextQuerySupportArrayList<R> newSupportSearchAfter(List<E> source, Function<? super E, ? extends R> mapper, Function<? super E, String> searchAfterSupplier) {
        String searchAfter;
        if (source.isEmpty()) {
            return EMPTY;
        }
        NextQuerySupportArrayList newlist = source.stream().map(mapper).collect(Collectors.toCollection(() -> new NextQuerySupportArrayList()));
        newlist.searchAfter = searchAfter = searchAfterSupplier.apply(source.get(source.size() - 1));
        newlist.hasNextPage = searchAfter != null;
        return newlist;
    }

    public static final <E> NextQuerySupportList<E> empty() {
        return EMPTY;
    }

    @Override
    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    @Override
    public String getSearchAfter() {
        return this.searchAfter;
    }
}

