/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.serialization;

import com.caucho.hessian.io.Hessian2Input;
import io.github.icodegarden.commons.lang.serialization.Deserializer;
import io.github.icodegarden.commons.lang.serialization.Hessian2Serializer;
import io.github.icodegarden.commons.lang.serialization.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hessian2Deserializer
implements Deserializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(Hessian2Deserializer.class);

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Hessian2Input input = new Hessian2Input((InputStream)is);
        input.setSerializerFactory(Hessian2Serializer.serializerFactory);
        try {
            Object object = input.readObject();
            return object;
        }
        catch (Throwable e) {
            throw new SerializationException("Error when deserializing byte[] to object", e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                log.error("ex on close hessian2 input", (Throwable)e);
            }
        }
    }
}

