/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.serialization;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.ExtSerializerFactory;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import io.github.icodegarden.commons.lang.serialization.SerializationException;
import io.github.icodegarden.commons.lang.serialization.Serializer;
import io.github.icodegarden.commons.lang.util.SystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hessian2Serializer
implements Serializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(Hessian2Serializer.class);
    static SerializerFactory serializerFactory = new SerializerFactory();

    public static void configSerializerFactory(SerializerFactory serializerFactory) {
        Hessian2Serializer.serializerFactory = serializerFactory;
    }

    @Override
    public byte[] serialize(Object obj) throws SerializationException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        Hessian2Output output = new Hessian2Output((OutputStream)os);
        output.setSerializerFactory(serializerFactory);
        try {
            output.writeObject(obj);
            output.flushBuffer();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            throw new SerializationException("Error when serializing object to byte[]", e);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                log.error("ex on close hessian2 output", (Throwable)e);
            }
        }
    }

    static {
        ExtSerializerFactory extSerializerFactory = new ExtSerializerFactory();
        extSerializerFactory.addSerializer(LocalDateTime.class, (com.caucho.hessian.io.Serializer)new LocalDateTimeSerializer());
        extSerializerFactory.addDeserializer(LocalDateTime.class, (Deserializer)new LocalDateTimeDeserializer());
        serializerFactory.addFactory((AbstractSerializerFactory)extSerializerFactory);
    }

    static class LocalDateTimeDeserializer
    extends AbstractDeserializer {
        LocalDateTimeDeserializer() {
        }

        public Class<?> getType() {
            return LocalDateTime.class;
        }

        public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
            String[] fieldNames = (String[])fields;
            int ref = in.addRef(null);
            String time = null;
            for (String key : fieldNames) {
                if ("value".equals(key)) {
                    time = in.readString();
                    continue;
                }
                in.readObject();
            }
            Object value = this.create(time);
            in.setRef(ref, value);
            return value;
        }

        private Object create(String time) throws IOException {
            return LocalDateTime.parse(time, SystemUtils.STANDARD_DATETIMEMS_FORMATTER);
        }
    }

    static class LocalDateTimeSerializer
    extends AbstractSerializer {
        LocalDateTimeSerializer() {
        }

        public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
            if (obj == null) {
                out.writeNull();
            } else {
                Class<?> cl = obj.getClass();
                if (out.addRef(obj)) {
                    return;
                }
                int ref = out.writeObjectBegin(cl.getName());
                if (ref < -1) {
                    out.writeString("value");
                    String time = SystemUtils.STANDARD_DATETIMEMS_FORMATTER.format((LocalDateTime)obj);
                    out.writeString(time);
                    out.writeMapEnd();
                } else {
                    if (ref == -1) {
                        out.writeInt(1);
                        out.writeString("value");
                        out.writeObjectBegin(cl.getName());
                    }
                    String time = SystemUtils.STANDARD_DATETIMEMS_FORMATTER.format((LocalDateTime)obj);
                    out.writeString(time);
                }
            }
        }
    }
}

