/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.serialization;

import io.github.icodegarden.commons.lang.serialization.Deserializer;
import io.github.icodegarden.commons.lang.serialization.SerializationException;
import io.github.icodegarden.commons.lang.serialization.StringDeserializer;
import io.github.icodegarden.commons.lang.util.JsonUtils;
import org.springframework.util.Assert;

public class JsonDeserializer
implements Deserializer<Object> {
    private final StringDeserializer deserializer = new StringDeserializer();
    private Class<?> type;

    public JsonDeserializer setType(Class<?> type) {
        this.type = type;
        return this;
    }

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        Assert.notNull(this.type, (String)"type must not null");
        String json = this.deserializer.deserialize(bytes);
        return JsonUtils.deserialize(json, this.type);
    }

    public Object deserialize(byte[] bytes, Class<?> type) throws SerializationException {
        String json = this.deserializer.deserialize(bytes);
        return JsonUtils.deserialize(json, type);
    }
}

