/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.serialization;

import io.github.icodegarden.commons.lang.serialization.Deserializer;
import io.github.icodegarden.commons.lang.serialization.SerializationException;
import java.io.UnsupportedEncodingException;

public class StringDeserializer
implements Deserializer<String> {
    private String encoding = "UTF8";

    @Override
    public String deserialize(byte[] data) throws SerializationException {
        try {
            if (data == null) {
                return null;
            }
            return new String(data, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when deserializing byte[] to string due to unsupported encoding " + this.encoding);
        }
    }
}

