/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.spec.response;

import io.github.icodegarden.commons.lang.spec.response.ApiResponse;
import io.github.icodegarden.commons.lang.spec.response.ErrorCodeException;
import java.util.Objects;

public class OpenApiResponse
extends ApiResponse {
    private String biz_code;
    private String biz_content;
    private String sign;

    public static OpenApiResponse success(String biz_code, String biz_content) {
        OpenApiResponse apiResponse = new OpenApiResponse();
        apiResponse.setCode("10000");
        apiResponse.setMsg("Success");
        apiResponse.setBiz_code(biz_code);
        apiResponse.setBiz_content(biz_content);
        return apiResponse;
    }

    public static OpenApiResponse fail(String biz_code, ErrorCodeException e) {
        OpenApiResponse apiResponse = new OpenApiResponse();
        apiResponse.setCode(e.getCode());
        apiResponse.setMsg(e.getMsg());
        apiResponse.setSub_code(e.getSub_code());
        apiResponse.setSub_msg(e.getSub_msg());
        apiResponse.setBiz_code(biz_code);
        return apiResponse;
    }

    public String getBiz_code() {
        return this.biz_code;
    }

    public void setBiz_code(String biz_code) {
        this.biz_code = biz_code;
    }

    public String getBiz_content() {
        return this.biz_content;
    }

    public void setBiz_content(String biz_content) {
        this.biz_content = biz_content;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.biz_code, this.biz_content, this.sign);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenApiResponse other = (OpenApiResponse)obj;
        return Objects.equals(this.biz_code, other.biz_code) && Objects.equals(this.biz_content, other.biz_content) && Objects.equals(this.sign, other.sign);
    }

    @Override
    public String toString() {
        return "OpenApiResponse [biz_code=" + this.biz_code + ", biz_content=" + this.biz_content + ", sign=" + this.sign + ", toString()=" + super.toString() + "]";
    }
}

