/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.tuple;

import io.github.icodegarden.commons.lang.tuple.NullableTuple2;
import io.github.icodegarden.commons.lang.tuple.NullableTuple3;
import io.github.icodegarden.commons.lang.tuple.NullableTuple4;
import io.github.icodegarden.commons.lang.tuple.NullableTuple5;
import io.github.icodegarden.commons.lang.tuple.NullableTuple6;
import io.github.icodegarden.commons.lang.tuple.NullableTuple7;
import io.github.icodegarden.commons.lang.tuple.NullableTuple8;
import java.util.function.Function;

public abstract class NullableTuples
implements Function {
    static final NullableTuples empty = new NullableTuples(){};

    public static NullableTuple2 fromArray(Object[] list) {
        if (list == null || list.length < 2) {
            throw new IllegalArgumentException("null or too small array, need between 2 and 8 values");
        }
        switch (list.length) {
            case 2: {
                return NullableTuples.of(list[0], list[1]);
            }
            case 3: {
                return NullableTuples.of(list[0], list[1], list[2]);
            }
            case 4: {
                return NullableTuples.of(list[0], list[1], list[2], list[3]);
            }
            case 5: {
                return NullableTuples.of(list[0], list[1], list[2], list[3], list[4]);
            }
            case 6: {
                return NullableTuples.of(list[0], list[1], list[2], list[3], list[4], list[5]);
            }
            case 7: {
                return NullableTuples.of(list[0], list[1], list[2], list[3], list[4], list[5], list[6]);
            }
            case 8: {
                return NullableTuples.of(list[0], list[1], list[2], list[3], list[4], list[5], list[6], list[7]);
            }
        }
        throw new IllegalArgumentException("too many arguments (" + list.length + "), need between 2 and 8 values");
    }

    public static <T1, T2> NullableTuple2<T1, T2> of(T1 t1, T2 t2) {
        return new NullableTuple2<T1, T2>(t1, t2);
    }

    public static <T1, T2, T3> NullableTuple3<T1, T2, T3> of(T1 t1, T2 t2, T3 t3) {
        return new NullableTuple3<T1, T2, T3>(t1, t2, t3);
    }

    public static <T1, T2, T3, T4> NullableTuple4<T1, T2, T3, T4> of(T1 t1, T2 t2, T3 t3, T4 t4) {
        return new NullableTuple4<T1, T2, T3, T4>(t1, t2, t3, t4);
    }

    public static <T1, T2, T3, T4, T5> NullableTuple5<T1, T2, T3, T4, T5> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        return new NullableTuple5<T1, T2, T3, T4, T5>(t1, t2, t3, t4, t5);
    }

    public static <T1, T2, T3, T4, T5, T6> NullableTuple6<T1, T2, T3, T4, T5, T6> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {
        return new NullableTuple6<T1, T2, T3, T4, T5, T6>(t1, t2, t3, t4, t5, t6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> NullableTuple7<T1, T2, T3, T4, T5, T6, T7> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7) {
        return new NullableTuple7<T1, T2, T3, T4, T5, T6, T7>(t1, t2, t3, t4, t5, t6, t7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> NullableTuple8<T1, T2, T3, T4, T5, T6, T7, T8> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8) {
        return new NullableTuple8<T1, T2, T3, T4, T5, T6, T7, T8>(t1, t2, t3, t4, t5, t6, t7, t8);
    }

    public static Function<Object[], NullableTuple2> fnAny() {
        return empty;
    }

    public static <R> Function<Object[], R> fnAny(Function<NullableTuple2, R> delegate) {
        return objects -> delegate.apply(NullableTuples.fnAny().apply((Object[])objects));
    }

    public static <T1, T2> Function<Object[], NullableTuple2<T1, T2>> fn2() {
        return empty;
    }

    public static <T1, T2, T3> Function<Object[], NullableTuple3<T1, T2, T3>> fn3() {
        return empty;
    }

    public static <T1, T2, T3, R> Function<Object[], R> fn3(Function<NullableTuple3<T1, T2, T3>, R> delegate) {
        return objects -> delegate.apply(NullableTuples.fn3().apply((Object[])objects));
    }

    public static <T1, T2, T3, T4> Function<Object[], NullableTuple4<T1, T2, T3, T4>> fn4() {
        return empty;
    }

    public static <T1, T2, T3, T4, R> Function<Object[], R> fn4(Function<NullableTuple4<T1, T2, T3, T4>, R> delegate) {
        return objects -> delegate.apply(NullableTuples.fn4().apply((Object[])objects));
    }

    public static <T1, T2, T3, T4, T5> Function<Object[], NullableTuple5<T1, T2, T3, T4, T5>> fn5() {
        return empty;
    }

    public static <T1, T2, T3, T4, T5, R> Function<Object[], R> fn5(Function<NullableTuple5<T1, T2, T3, T4, T5>, R> delegate) {
        return objects -> delegate.apply(NullableTuples.fn5().apply((Object[])objects));
    }

    public static <T1, T2, T3, T4, T5, T6> Function<Object[], NullableTuple6<T1, T2, T3, T4, T5, T6>> fn6() {
        return empty;
    }

    public static <T1, T2, T3, T4, T5, T6, R> Function<Object[], R> fn6(Function<NullableTuple6<T1, T2, T3, T4, T5, T6>, R> delegate) {
        return objects -> delegate.apply(NullableTuples.fn6().apply((Object[])objects));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Function<Object[], NullableTuple7<T1, T2, T3, T4, T5, T6, T7>> fn7() {
        return empty;
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Function<Object[], R> fn7(Function<NullableTuple7<T1, T2, T3, T4, T5, T6, T7>, R> delegate) {
        return objects -> delegate.apply(NullableTuples.fn7().apply((Object[])objects));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Function<Object[], NullableTuple8<T1, T2, T3, T4, T5, T6, T7, T8>> fn8() {
        return empty;
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Function<Object[], R> fn8(Function<NullableTuple8<T1, T2, T3, T4, T5, T6, T7, T8>, R> delegate) {
        return objects -> delegate.apply(NullableTuples.fn8().apply((Object[])objects));
    }

    public NullableTuple2 apply(Object o) {
        return NullableTuples.fromArray((Object[])o);
    }

    static StringBuilder tupleStringRepresentation(Object ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            Object t = values[i];
            if (i != 0) {
                sb.append(',');
            }
            if (t == null) continue;
            sb.append(t);
        }
        return sb;
    }

    NullableTuples() {
    }
}

