/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;

public abstract class JsonUtils {
    public static final DateTimeFormatter STANDARD_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static ObjectMapper om = new ObjectMapper();

    private JsonUtils() {
    }

    public static String serialize(Object obj) throws IllegalArgumentException {
        try {
            return om.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("serialize json error", e);
        }
    }

    public static <T> T deserialize(String jsonObject, Class<T> cla) throws IllegalArgumentException {
        try {
            return (T)om.readValue(jsonObject, cla);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("deserialize json error", e);
        }
    }

    public static <T> List<T> deserializeArray(String jsonArray, Class<T> cla) throws IllegalArgumentException {
        try {
            JavaType javaType = om.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{cla});
            return (List)om.readValue(jsonArray, javaType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("deserialize json error", e);
        }
    }

    public static <P> P deserializeArray(String jsonArray, Class<?> cla, Class<P> parametrized) throws IllegalArgumentException {
        try {
            JavaType javaType = om.getTypeFactory().constructParametricType(parametrized, new Class[]{cla});
            return (P)om.readValue(jsonArray, javaType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("deserialize json error", e);
        }
    }

    public static <T> T deserialize(String json, ParameterizedTypeReference<T> typeReference) throws IllegalArgumentException {
        Type responseType = typeReference.getType();
        return JsonUtils.deserialize(json, responseType);
    }

    public static <T> T deserialize(String json, Type responseType) throws IllegalArgumentException {
        try {
            JavaType javaType = om.constructType(responseType);
            return (T)om.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("deserialize json error", e);
        }
    }

    public static <T> T deserialize(InputStream in, Type responseType) throws IllegalArgumentException {
        try {
            JavaType javaType = om.constructType(responseType);
            return (T)om.readValue(in, javaType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("deserialize json error", e);
        }
    }

    static {
        om = new ObjectMapper();
        om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        om.configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, true);
        om.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new JsonSerializer<LocalDateTime>(){

            public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(STANDARD_DATETIME_FORMATTER.format(localDateTime));
            }
        });
        timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JsonDeserializer<LocalDateTime>(){

            public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                String valueAsString = jsonParser.getValueAsString();
                return LocalDateTime.parse(valueAsString, STANDARD_DATETIME_FORMATTER);
            }
        });
        om.registerModule((Module)timeModule);
    }
}

