/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang;

import io.github.icodegarden.commons.lang.NamedObject;
import io.github.icodegarden.commons.lang.NamedObjectReader;
import io.github.icodegarden.commons.lang.util.ThreadPoolUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesCachedObjectReader
implements NamedObjectReader<NamedObject>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(NamesCachedObjectReader.class);
    private static final long DEFAULT_CACHE_REFRESH_INTERVAL_MILLIS = 10000L;
    private final ScheduledThreadPoolExecutor scheduleRefreshCacheThreadPool = ThreadPoolUtils.newSingleScheduledThreadPool("NamesCachedObjectReader-refreshCache");
    private final Map<String, List<? extends NamedObject>> name_objects;
    private final Collection<String> names;
    private final NamedObjectReader<? extends NamedObject> delegator;

    public NamesCachedObjectReader(Collection<String> names, NamedObjectReader<? extends NamedObject> delegator) {
        this(names, delegator, 10000L);
    }

    public NamesCachedObjectReader(Collection<String> names, NamedObjectReader<? extends NamedObject> delegator, long cacheRefreshIntervalMillis) {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("names must not empty");
        }
        if (delegator == null) {
            throw new IllegalArgumentException("delegator must not null");
        }
        this.names = names;
        this.delegator = delegator;
        this.name_objects = new HashMap<String, List<? extends NamedObject>>(names.size(), 1.0f);
        for (String name : names) {
            this.name_objects.put(name, new LinkedList());
        }
        this.scheduleRefreshCacheThreadPool.scheduleWithFixedDelay(() -> {
            try {
                this.refreshCache();
            }
            catch (Exception e) {
                log.error("WARNING ex on refreshCache", (Throwable)e);
            }
        }, 0L, cacheRefreshIntervalMillis, TimeUnit.MILLISECONDS);
    }

    void refreshCache() {
        for (String name : this.names) {
            try {
                List<? extends NamedObject> listNamedObjects = this.delegator.listNamedObjects(name);
                if (listNamedObjects.isEmpty()) continue;
                this.name_objects.put(name, listNamedObjects);
            }
            catch (Exception e) {
                log.error("WARNING ex on refreshCache, name:{}", (Object)name, (Object)e);
            }
        }
    }

    @Override
    public List<NamedObject> listNamedObjects(String name) {
        if (!this.names.contains(name)) {
            throw new IllegalArgumentException(String.format("name [%s] not supported, support names were [%s]", name, this.names));
        }
        List<? extends NamedObject> list = this.name_objects.get(name);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<NamedObject>(list);
    }

    public boolean addObject(NamedObject object) {
        List<? extends NamedObject> list = this.name_objects.get(object.name());
        if (list != null) {
            return list.add(object);
        }
        return false;
    }

    public boolean removeObject(NamedObject object) {
        List<? extends NamedObject> list = this.name_objects.get(object.name());
        if (list != null) {
            return list.remove(object);
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.scheduleRefreshCacheThreadPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduleRefreshCacheThreadPool.shutdown();
    }
}

