/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;

public final class InputStreamClassLoader
extends ClassLoader {
    private final String className;
    private InputStream is;
    private ClassLoader appClassLoader;

    public InputStreamClassLoader(String className, InputStream is) throws IOException {
        super(null);
        if (is.available() == 0) {
            throw new IOException("InputStream's available must > 0");
        }
        this.className = className;
        this.appClassLoader = InputStreamClassLoader.getSystemClassLoader();
        this.is = is;
    }

    public Class<?> loadClass() throws ClassNotFoundException {
        return this.loadClass(this.className);
    }

    public <T> T newInstance(Class<T> interfaceClass, Object ... initargs) throws Exception {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("class " + interfaceClass.getName() + " is not a interface");
        }
        Class<?> loaded = this.loadClass();
        Class[] parameterTypes = null;
        if (initargs != null && initargs.length > 0) {
            parameterTypes = new Class[initargs.length];
            for (int i = 0; i < initargs.length; ++i) {
                parameterTypes[i] = initargs[i].getClass();
            }
        }
        Constructor<?> declaredConstructor = loaded.getDeclaredConstructor(parameterTypes);
        return (T)declaredConstructor.newInstance(initargs);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            if (this.is == null) {
                return Class.forName(name);
            }
            byte[] b = new byte[this.is.available()];
            this.is.read(b);
            this.is = null;
            return this.defineClass(name, b, 0, b.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }
}

