/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.concurrent;

import io.github.icodegarden.commons.lang.concurrent.CloseableThread;
import java.io.IOException;

public abstract class AlwaysRunCloseableThread
extends CloseableThread {
    private volatile boolean closed;
    private Runnable target;

    public AlwaysRunCloseableThread() {
    }

    public AlwaysRunCloseableThread(Runnable target, String name) {
        super(target, name);
    }

    public AlwaysRunCloseableThread(Runnable target) {
        super(target);
    }

    public AlwaysRunCloseableThread(String name) {
        super(name);
    }

    @Override
    public final void run() {
        long loop = 0L;
        while (!this.closed) {
            if (this.target != null) {
                super.run();
            } else {
                this.doRun(loop);
            }
            if (loop == Long.MAX_VALUE) {
                loop = 0L;
            }
            ++loop;
        }
        this.doClose();
    }

    @Override
    public final void close() throws IOException {
        this.closed = true;
    }

    protected void doRun(long loop) {
        throw new RuntimeException("method must override on Runnable not given");
    }

    protected abstract void doClose();
}

